/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.login;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.ClearfySession;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.index.Index;

public class LoginPanel
extends ClearfySection {
    private final StatelessForm loginForm;
    private final Label loginIdCaption;
    private final TextField<String> loginId;
    private final Label loginPasswordCaption;
    private final PasswordTextField loginPassword;
    private final FeedbackPanel feedback;
    private final Button submit;
    private final Label loginDescription = new Label("loginDescription", (Serializable)((Object)this.getSentence("\u30e6\u30fc\u30b6\u30fcID\u3068\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3001\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u3002")));

    public LoginPanel(String id, ClearfyPage cls) {
        super(id, cls);
        this.add(this.loginDescription);
        this.loginForm = new StatelessForm("loginForm");
        this.loginIdCaption = new Label("loginIdCaption", Model.of(this.getSentence("\u30e6\u30fc\u30b6\u30fcID")));
        this.loginForm.add(this.loginIdCaption);
        this.loginId = new TextField<String>("loginId", (IModel<String>)Model.of(""));
        this.loginId.setRequired(true);
        this.loginForm.add(this.loginId);
        this.loginPasswordCaption = new Label("loginPasswordCaption", Model.of(this.getSentence("\u30d1\u30b9\u30ef\u30fc\u30c9")));
        this.loginForm.add(this.loginPasswordCaption);
        this.loginPassword = new PasswordTextField("loginPassword", (IModel<String>)Model.of(""));
        this.loginPassword.setRequired(true);
        this.loginForm.add(this.loginPassword);
        this.submit = new Button("submit", Model.of(this.getSentence("\u30ed\u30b0\u30a4\u30f3"))){

            @Override
            public void onSubmit() {
                LoginPanel.this.authenticate();
            }
        };
        this.loginForm.add(this.submit);
        this.feedback = new FeedbackPanel("feedback");
        this.loginForm.add(this.feedback);
        this.add(this.loginForm);
    }

    @Override
    public void drawContent() {
    }

    private void authenticate() {
        String userAccount = (String)this.loginId.getModelObject();
        String password = (String)this.loginPassword.getModelObject();
        ClearfySession newSession = (ClearfySession)this.getSession();
        if (newSession.signIn(userAccount, password)) {
            newSession.setSectionClass(null);
            throw new RestartResponseException(Index.class);
        }
        String msg = this.getString("msgLoginError");
        this.error((Serializable)((Object)msg));
    }

    private String getUserPassKey(String loginId) {
        String rvalue = "";
        String cmd = "Select * from USER where USER_ACCOUNT = '%s'";
        cmd = String.format(cmd, loginId);
        Jdbc controller = this.getDataController();
        ResultSet rs = controller.select(cmd);
        try {
            if (rs.next()) {
                rvalue = rs.getString("USER_PASSKEY");
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(LoginPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u30ed\u30b0\u30a4\u30f3");
    }
}

