/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.json;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.TextRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.clearfy.ClearfyApplication;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.json.QueryResult;
import org.clearfy.json.RequestParameter;
import org.clearfy.json.RequestParameters;

public class Request
extends WebPage
implements IJdbcSupplier {
    public static final String REQUEST_PARAM_METHOD = "method";
    private final RequestParameters requestParameters;
    protected boolean paramOk = true;

    public Request(PageParameters parameters) {
        RequestCycle cycle = this.getRequestCycle();
        IRequestParameters params = cycle.getRequest().getPostParameters();
        this.requestParameters = new RequestParameters(params, parameters);
        if (this.checkApikey(this.requestParameters.get("apikey").getValue())) {
            this.paramOk = true;
            this.onRecieved(this.requestParameters);
        } else {
            String code = this.getErrorMessage("API key is null or not valid.");
            this.putJson(code);
        }
    }

    public void onRecieved(RequestParameters requestParams) {
        String jsondata = "";
        for (RequestParameter rparam : requestParams) {
            String fmt = "\"%s\":\"%s\",\n";
            fmt = String.format(fmt, rparam.getName(), rparam.getValue());
            jsondata = jsondata + fmt;
        }
        jsondata = jsondata.trim();
        jsondata = jsondata.substring(0, jsondata.length() - 1);
        jsondata = "{\"STATUS\":\"SUCCESS\",\"parameters\":{\n" + jsondata + "\n}}";
        this.putJson(jsondata);
    }

    public final void putJson(String jsonData) {
        this.getRequestCycle().scheduleRequestHandlerAfterCurrent(new TextRequestHandler("application/json", "UTF-8", jsonData));
    }

    public RequestParameters getRequstParameters() {
        return this.requestParameters;
    }

    public final String getErrorMessage(String message) {
        String rvalue = "{\"STATUS\":\"ERROR\",\"MESSAGE\":\"%s\"}";
        rvalue = String.format(rvalue, message);
        return rvalue;
    }

    public final boolean checkApikey(String apikey) {
        boolean rvalue = false;
        String cmd = "select count(*) reccount from USER where USER_APIKEY = '%s'";
        cmd = String.format(cmd, apikey);
        ResultSet rs = ((ClearfyApplication)this.getApplication()).getJdbc().select(cmd);
        try {
            int result;
            if (rs.next() && (result = rs.getInt("reccount")) > 0) {
                rvalue = true;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(QueryResult.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public final String getParameter(String param) {
        String rvalue = null;
        if (this.paramOk) {
            String data = this.getRequstParameters().get(param).getValue();
            if (data == null) {
                this.putJson(this.getErrorMessage(param + " IS NULL."));
                this.paramOk = false;
            } else if (data.length() == 0) {
                this.putJson(this.getErrorMessage(param + " IS NEEDED."));
                this.paramOk = false;
            }
            rvalue = data;
        }
        return rvalue;
    }

    public final String getNullableParameter(String param) {
        String data = this.getRequstParameters().get(param).getValue();
        if (data == null) {
            return "";
        }
        return data;
    }

    @Override
    public Jdbc getJdbc() {
        return ((ClearfyApplication)this.getApplication()).getJdbc();
    }
}

