/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.json;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.clearfy.ClearfyApplication;
import org.clearfy.json.Request;
import org.clearfy.json.RequestParameters;

public class QueryResult
extends Request {
    public QueryResult(PageParameters parameters) {
        super(parameters);
    }

    @Override
    public void onRecieved(RequestParameters params) {
        String table = this.getParameter("table");
        String fieldorder = this.getParameter("fields");
        String apiKey = this.getParameter("apikey");
        String where = this.getNullableParameter("where");
        if (this.paramOk && where != null) {
            if (!this.checkApikey(apiKey)) {
                String msg = this.getErrorMessage("MISSING API KEY.");
                this.putJson(msg);
                return;
            }
            if (where.length() > 0) {
                where = " where " + where;
            }
            String cmd = "select %s from %s %s";
            cmd = String.format(cmd, fieldorder, table, where);
            ResultSet rs = ((ClearfyApplication)this.getApplication()).getJdbc().select(cmd);
            String jsonResult = "";
            try {
                String[] fields = fieldorder.split(",");
                int order = 1;
                while (rs.next()) {
                    String row = "";
                    for (String field : fields) {
                        field = field.trim();
                        row = row + "\"" + field + "\":\"" + rs.getString(field) + "\", ";
                    }
                    row = row.trim();
                    row = row.substring(0, row.length() - 1);
                    row = "\"" + order + "\":{" + row + "}, \n";
                    jsonResult = jsonResult + row;
                    ++order;
                }
                if ((jsonResult = jsonResult.trim()).length() > 1) {
                    jsonResult = jsonResult.substring(0, jsonResult.length() - 1);
                }
                jsonResult = "{\n" + jsonResult + "\n}";
                jsonResult = "{\"STATUS\":\"SUCCESS\",\"DATA\":" + jsonResult + "\n}";
            }
            catch (SQLException ex) {
                Logger.getLogger(QueryResult.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.putJson(jsonResult);
        } else {
            this.putJson(this.getErrorMessage("SQL FAILED"));
        }
    }

    @Override
    protected void configureResponse(WebResponse response) {
        response.setContentType("application/json");
        super.configureResponse(response);
    }
}

