/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.datawrapper.h2db;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.datawrapper.Jdbc;
import org.h2.tools.Server;

public class ServerSwitch
implements IJdbcSupplier {
    protected static String JDBC_DRIVER_MANAGER = "org.h2.Driver";
    public static final int DATABASE_STOPED = 0;
    public static final int DATABASE_RUNNING = 1;
    public static final String DATABASE_MODE_TCP = "tcp";
    public static final String DATABASE_MODE_HTTP = "http";
    protected int dbStatus = 0;
    protected Server httpDbServer;
    protected Server tcpDbServer;
    protected int jdbcTcpPort = 0;
    protected int jdbcHttpPort = 0;
    private String JdbcDriverName = JDBC_DRIVER_MANAGER;
    private String url;

    public void loadDriver() {
        this.loadDriver(this.JdbcDriverName);
    }

    public void loadDriver(String name) {
        try {
            Class.forName(name);
            this.JdbcDriverName = name;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ServerSwitch.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Jdbc getJdbc() {
        Jdbc rvalue = new Jdbc(this.url);
        return rvalue;
    }

    public void setServerPorts(int tcpPort, int httpPort) {
        this.jdbcHttpPort = httpPort;
        this.jdbcTcpPort = tcpPort;
    }

    public void on() {
        try {
            if (this.jdbcHttpPort > 0) {
                this.httpDbServer = Server.createWebServer("-webPort", String.valueOf(this.jdbcHttpPort), "-webAllowOthers").start();
            }
            if (this.jdbcTcpPort > 0) {
                this.tcpDbServer = Server.createTcpServer("-tcpPort", String.valueOf(this.jdbcTcpPort), "-tcpAllowOthers").start();
            }
            this.dbStatus = 1;
        }
        catch (SQLException ex) {
            Logger.getLogger(ServerSwitch.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getStatus() {
        return this.dbStatus;
    }

    public void off() {
        if (this.httpDbServer != null) {
            this.httpDbServer.stop();
        }
        if (this.tcpDbServer != null) {
            this.tcpDbServer.stop();
        }
        this.dbStatus = 0;
    }
}

