/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.datawrapper;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.annotations.Comment;
import org.clearfy.annotations.LogicalName;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Column;
import org.clearfy.datawrapper.ColumnInfo;
import org.clearfy.datawrapper.Condition;
import org.clearfy.datawrapper.CurrentTimestamp;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.datawrapper.IncrementalKey;
import org.clearfy.datawrapper.MD5Column;
import org.clearfy.datawrapper.NameDescriptor;
import org.clearfy.datawrapper.SelectionDescriptor;
import org.clearfy.datawrapper.ShortFlagZero;
import org.clearfy.datawrapper.TableInfo;
import org.clearfy.datawrapper.Translate;

public abstract class Table
extends ArrayList<Column> {
    public static final int JOIN_TYPE_INNER = 0;
    public static final int JOIN_TYPE_LEFT = 1;
    public static final int JOIN_TYPE_RIGHT = 2;
    private String name;
    private String alias;
    private IJdbcSupplier supplier;
    private boolean matched = false;
    private int joinType = 0;

    public Table() {
        this.initialize();
    }

    private void initialize() {
        this.alias = this.name = NameDescriptor.toSqlName(this.getClass().getSimpleName());
        try {
            this.generateColumns();
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.defineColumns();
    }

    public void setJdbcSupplier(IJdbcSupplier supplier) {
        this.supplier = supplier;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return NameDescriptor.toJavaName(this.name);
    }

    public String getAlias() {
        return this.alias;
    }

    public Table setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public Table removeAlias() {
        this.alias = "";
        return this;
    }

    public boolean hasAlias() {
        return !this.alias.equals(this.name);
    }

    public String getNameWithAlias() {
        String rvalue = this.getName();
        if (this.hasAlias()) {
            rvalue = rvalue + " " + this.getAlias();
        }
        return rvalue;
    }

    private void generateColumns() throws ClearfyDatabaseException {
        Field[] fields;
        String mypackage = Table.class.getPackage().getName();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            String fieldTypeName = field.getType().getTypeName();
            boolean pass = false;
            if (fieldTypeName.equals(Column.class.getTypeName())) {
                pass = true;
            } else if (field.getType().getSuperclass() != null && field.getType().getSuperclass().equals(Column.class)) {
                pass = true;
            }
            if (!pass) continue;
            try {
                String columnName = NameDescriptor.toSqlName(field.getName());
                String ClsType = field.getGenericType().toString();
                Column newColumn = null;
                if (ClsType.equals(mypackage + ".Column<java.lang.Integer>")) {
                    newColumn = new Column();
                    ClsType = Integer.class.getSimpleName();
                } else if (ClsType.equals(mypackage + ".Column<java.lang.Short>")) {
                    newColumn = new Column();
                    ClsType = Short.class.getSimpleName();
                } else if (ClsType.equals(mypackage + ".Column<java.sql.Timestamp>")) {
                    newColumn = new Column();
                    ClsType = Timestamp.class.getSimpleName();
                } else if (ClsType.equals(mypackage + ".Column<java.sql.Date>")) {
                    newColumn = new Column();
                    ClsType = Date.class.getSimpleName();
                } else if (ClsType.equals(mypackage + ".Column<java.sql.Time>")) {
                    newColumn = new Column();
                    ClsType = Date.class.getSimpleName();
                } else if (ClsType.equals(mypackage + ".Column<java.lang.String>")) {
                    newColumn = new Column();
                    newColumn.setLength(32);
                    ClsType = String.class.getSimpleName();
                } else if (ClsType.equals(mypackage + ".Column<char[]>")) {
                    newColumn = new Column();
                    newColumn.setLength(32);
                    ClsType = char[].class.getSimpleName();
                } else if (ClsType.equals(mypackage + ".Column<java.math.BigDecimal>")) {
                    newColumn = new Column();
                    newColumn.setLength(18, 9);
                    ClsType = BigDecimal.class.getSimpleName();
                } else if (ClsType.equals("class " + mypackage + ".IncrementalKey")) {
                    newColumn = new IncrementalKey();
                    ClsType = Integer.class.getSimpleName();
                } else if (ClsType.equals("class " + mypackage + ".CurrentTimestamp")) {
                    newColumn = new CurrentTimestamp();
                    ClsType = Timestamp.class.getSimpleName();
                } else if (ClsType.equals("class " + mypackage + ".ShortFlagZero")) {
                    newColumn = new ShortFlagZero();
                    ClsType = Short.class.getSimpleName();
                } else if (ClsType.equals("class " + mypackage + ".MD5Column")) {
                    newColumn = new MD5Column();
                    ClsType = String.class.getSimpleName();
                } else {
                    throw new ClearfyDatabaseException("unsupported type " + ClsType);
                }
                newColumn.setVisibleType(1);
                newColumn.setTable(this);
                this.add(newColumn);
                Class<?> ccls = newColumn.getClass();
                while (!ccls.equals(Column.class)) {
                    ccls = ccls.getSuperclass();
                }
                Field clmField = ccls.getDeclaredField("typeName");
                clmField.setAccessible(true);
                clmField.set(newColumn, ClsType);
                clmField = ccls.getDeclaredField("name");
                clmField.setAccessible(true);
                clmField.set(newColumn, columnName);
                field.set(this, newColumn);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public abstract void defineColumns();

    public String getColumnSqlType(Column col) {
        String variableSize;
        String rvalue = col.getType();
        if (rvalue.equals(Integer.class.getSimpleName())) {
            rvalue = "int";
        }
        if (rvalue.equals(Short.class.getSimpleName())) {
            rvalue = "smallint";
        }
        if (rvalue.equals(Timestamp.class.getSimpleName())) {
            rvalue = "timestamp";
        }
        if (rvalue.equals(Date.class.getSimpleName())) {
            rvalue = "date";
        }
        if (rvalue.equals(Time.class.getSimpleName())) {
            rvalue = "time";
        }
        if (rvalue.equals(String.class.getSimpleName())) {
            rvalue = "varchar%s";
            variableSize = col.getVariableSize();
            rvalue = String.format(rvalue, variableSize);
        }
        if (rvalue.equals(char[].class.getSimpleName())) {
            rvalue = "char%s";
            variableSize = col.getVariableSize();
            rvalue = String.format(rvalue, variableSize);
        }
        if (rvalue.equals(BigDecimal.class.getSimpleName())) {
            rvalue = "decimal%s";
            variableSize = col.getVariableSize();
            rvalue = String.format(rvalue, variableSize);
        }
        return rvalue;
    }

    public String getCreateSentence() {
        Field[] fields;
        String rvalue = "create table if not exists %s (\n %s\n)\n";
        String fieldLine = " %s %s %s %s %s,\n";
        String fieldDef = "";
        String pkeydef = "";
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            boolean usefield = false;
            if (field.getType().getTypeName().equals(Column.class.getTypeName())) {
                usefield = true;
            } else if (field.getType().getSuperclass() != null && field.getType().getSuperclass().getTypeName().equals(Column.class.getTypeName())) {
                usefield = true;
            }
            if (!usefield) continue;
            try {
                String variableSize;
                Column col = (Column)field.get(this);
                String fieldType = col.getType();
                String autoIncrement = "";
                String nullable = "";
                String defaultValue = "";
                if (fieldType.equals(Integer.class.getSimpleName())) {
                    fieldType = "int";
                }
                if (fieldType.equals(Short.class.getSimpleName())) {
                    fieldType = "smallint";
                }
                if (fieldType.equals(Timestamp.class.getSimpleName())) {
                    fieldType = "timestamp";
                }
                if (fieldType.equals(Date.class.getSimpleName())) {
                    fieldType = "date";
                }
                if (fieldType.equals(Time.class.getSimpleName())) {
                    fieldType = "time";
                }
                if (fieldType.equals(String.class.getSimpleName())) {
                    fieldType = "varchar%s";
                    variableSize = col.getVariableSize();
                    fieldType = String.format(fieldType, variableSize);
                }
                if (fieldType.equals(char[].class.getSimpleName())) {
                    fieldType = "char%s";
                    variableSize = col.getVariableSize();
                    fieldType = String.format(fieldType, variableSize);
                }
                if (fieldType.equals(BigDecimal.class.getSimpleName())) {
                    fieldType = "decimal%s";
                    variableSize = col.getVariableSize();
                    fieldType = String.format(fieldType, variableSize);
                }
                if (col.isPrimaryKey()) {
                    pkeydef = pkeydef + col.getName() + ",";
                }
                if (col.isAutoIncrement()) {
                    autoIncrement = "AUTO_INCREMENT";
                }
                if (!col.isNullable()) {
                    nullable = "not null";
                }
                if (col.getDefault().length() > 0) {
                    defaultValue = "default " + col.getDefault();
                }
                fieldDef = fieldDef + String.format(fieldLine, col.getName(), fieldType, nullable, autoIncrement, defaultValue);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (pkeydef.length() > 0) {
            pkeydef = pkeydef.substring(0, pkeydef.length() - 1);
            String fmt = " primary key (%s),";
            fmt = String.format(fmt, pkeydef);
            fieldDef = fieldDef + fmt;
        }
        fieldDef = fieldDef.trim();
        fieldDef = fieldDef.substring(0, fieldDef.length() - 1);
        rvalue = String.format(rvalue, this.getName(), fieldDef);
        return rvalue;
    }

    public void selectAllColumn() {
        this.forEach((? super E col) -> col.setSelectable(true));
    }

    public void setMargeTargetAll() {
        this.forEach((? super E col) -> col.setMargeTarget(true));
    }

    public void unselectAllColumn() {
        for (Column col : this) {
            col.setSelectable(false);
        }
    }

    public String getSelectSentence(Condition ... conditions) throws ClearfyDatabaseException {
        String se = new SelectionDescriptor().getSelectSentence(this, conditions);
        return se;
    }

    public int getSelectCount(Condition ... conditions) {
        int rvalue = -1;
        try {
            String cmd = this.getSelectSentence(conditions);
            cmd = "select count(*) rcount from (" + cmd + ") rcq";
            ResultSet rs = this.supplier.getJdbc().select(cmd);
            if (rs.next()) {
                rvalue = rs.getInt("rcount");
            }
        }
        catch (SQLException | ClearfyDatabaseException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public ResultSet select(Condition ... conditions) {
        ResultSet rvalue = null;
        try {
            String cmd = this.getSelectSentence(conditions);
            rvalue = this.supplier.getJdbc().select(cmd);
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public ResultSet select(String cmd) {
        ResultSet rs = this.supplier.getJdbc().select(cmd);
        return rs;
    }

    public void createTable() {
        if (this.supplier != null) {
            String cmd = this.getCreateSentence();
            this.supplier.getJdbc().execute(cmd);
            Logger.getLogger(this.getJavaName()).log(Level.INFO, "CREATE.");
        }
    }

    public boolean isExist() {
        boolean rvalue = false;
        if (this.supplier != null) {
            rvalue = this.supplier.getJdbc().isExistTable(this.getName());
        }
        return rvalue;
    }

    public boolean merge(Column ... columns) {
        String fields = "";
        String values = "";
        for (Column column : columns) {
            if (!column.isMargeTarget()) continue;
            fields = fields + "," + column.getName();
            if (column.getValue() == null || column.getValue().toString().length() < 1) {
                if (column.isNullable()) {
                    values = values + ", null";
                    continue;
                }
                if (column.getType().equals(Integer.class.getSimpleName()) && column.isAutoIncrement()) {
                    values = values + ", null";
                    continue;
                }
                if (column.getType().equals(Timestamp.class.getSimpleName()) && column.getDefault().equals("CURRENT_TIMESTAMP")) {
                    values = values + ",CURRENT_TIMESTAMP";
                    continue;
                }
                if (column.getDefault().length() > 0) {
                    values = values + ", '" + column.getDefault() + "'";
                    continue;
                }
                values = values + ", ''";
                continue;
            }
            if (column.getType().equals(char[].class.getSimpleName())) {
                char[] value = (char[])column.getValue();
                values = values + ",'" + String.copyValueOf(value) + "'";
                continue;
            }
            values = values + ",'" + String.valueOf(column.getValue()) + "'";
        }
        fields = fields.substring(1);
        values = values.substring(1);
        String cmd = "merge into %s (%s) values (%s)";
        cmd = String.format(cmd, this.getName(), fields, values);
        System.out.println(cmd);
        return this.supplier.getJdbc().execute(cmd);
    }

    public boolean insert(Column ... columns) {
        String fields = "";
        String values = "";
        for (Column column : columns) {
            fields = fields + "," + column.getName();
            values = values + ",'" + column.getValue().toString() + "'";
        }
        fields = fields.substring(1);
        values = values.substring(1);
        String cmd = "insert into %s (%s) values (%s)";
        cmd = String.format(cmd, this.getName(), fields, values);
        return this.supplier.getJdbc().execute(cmd);
    }

    public boolean merge() throws NullPointerException {
        Column[] columns = new Column[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            columns[i] = (Column)this.get(i);
        }
        return this.merge(columns);
    }

    public void monitorSqlCommand(String sql) {
        System.out.println(sql);
    }

    public boolean insert() throws NullPointerException {
        String fields = "";
        String values = "";
        for (Column column : this) {
            if (!column.hasValue()) continue;
            fields = fields + "," + column.getName();
            values = values + ",'" + column.getValue().toString() + "'";
        }
        fields = fields.substring(1).trim();
        values = values.substring(1).trim();
        if (fields.length() < 1) {
            throw new NullPointerException("At table [" + this.getName() + "], columns have not values on merge datas.");
        }
        String cmd = "insert into %s (%s) values (%s)";
        cmd = String.format(cmd, this.getName(), fields, values);
        return this.supplier.getJdbc().execute(cmd);
    }

    public void alterOrCreateTable(IJdbcSupplier supplier) {
        this.setJdbcSupplier(supplier);
        if (!this.isExist()) {
            this.createTable();
        } else {
            try {
                ResultSet columns = this.supplier.getJdbc().getConnection().getMetaData().getColumns(null, null, this.getName().toUpperCase(), "%");
                while (columns.next()) {
                    String colName = columns.getString("COLUMN_NAME");
                    if (!this.isMyColumn(colName.toLowerCase())) continue;
                    this.checkColumnAndUpdate(columns);
                }
                for (Column col : this) {
                    if (!this.isAppendedColumn(col.getName())) continue;
                    this.alterTableAddColumn(col);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void recordInfo(IJdbcSupplier supplier) {
        TableInfo tableInfo = new TableInfo();
        tableInfo.setJdbcSupplier(supplier);
        if (!tableInfo.isExist()) {
            tableInfo.alterOrCreateTable(supplier);
        }
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setJdbcSupplier(supplier);
        if (!columnInfo.isExist()) {
            columnInfo.alterOrCreateTable(supplier);
        }
        String tablePhisicalName = this.getName();
        String tableLogicalName = this.getLogicalName();
        String tableClassName = this.getClass().getCanonicalName();
        tableInfo.clearValues();
        tableInfo.TableClassName.setValue(tableClassName);
        tableInfo.TablePhisicalName.setValue(tablePhisicalName);
        tableInfo.TableLogicalName.setValue(tableLogicalName);
        tableInfo.merge();
        tableInfo.unselectAllColumn();
        tableInfo.TableInfoId.setSelectable(true);
        ResultSet rs = tableInfo.select(tableInfo.TableClassName.sameValueOf(tableClassName));
        try {
            if (rs.next()) {
                int tableInfoId = tableInfo.TableInfoId.of(rs);
                for (int i = 0; i < this.size(); ++i) {
                    Column column = (Column)this.get(i);
                    String columnPhisicalName = column.getName();
                    String columnLogicalName = this.getColumnLogicalName(column);
                    String columnClassName = column.getClass().getPackage().getName() + "." + this.getJavaName() + "." + column.getJavaName();
                    columnInfo.clearValues();
                    columnInfo.ColumnClassName.setValue(columnClassName);
                    columnInfo.ColumnPhisicalName.setValue(columnPhisicalName);
                    columnInfo.ColumnLogicalName.setValue(columnLogicalName);
                    columnInfo.TableInfoId.setValue(tableInfoId);
                    columnInfo.Ordinal.setValue(i + 1);
                    columnInfo.ColumnType.setValue(column.getType());
                    columnInfo.ColumnLength.setValue(column.getVariableSize());
                    columnInfo.AllowNullable.setValue(column.isNullable() ? (short)1 : 0);
                    columnInfo.Description.setValue(this.getColumnComment(column));
                    columnInfo.merge();
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getLogicalName() {
        String rvalue = this.getClass().getAnnotation(LogicalName.class).value();
        if (rvalue == null) {
            rvalue = "Annotation LogicalName is not defined.";
        }
        return rvalue;
    }

    public String getColumnLogicalName(Column col) {
        String rvalue = null;
        try {
            Field f = this.getClass().getField(col.getJavaName());
            LogicalName lname = f.getAnnotation(LogicalName.class);
            rvalue = lname == null ? "Annotation LogicalName is not defined." : lname.value();
        }
        catch (NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public String getColumnComment(Column column) {
        String rvalue = null;
        try {
            Field f = this.getClass().getField(column.getJavaName());
            Comment comment = f.getAnnotation(Comment.class);
            rvalue = comment == null ? null : comment.value();
        }
        catch (NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private void alterTableAddColumn(Column column) {
        String colType = this.getColumnSqlType(column);
        String nullable = "";
        if (!column.isNullable()) {
            nullable = "not null";
        }
        String def = "";
        if (column.getDefault().length() > 0) {
            def = "default " + column.getDefault();
        }
        if (column.isAutoIncrement()) {
            def = "AUTO_INCREMENT";
        }
        String addline = "alter table if exists %s add column if not exists %s %s %s %s";
        addline = String.format(addline, this.getName(), column.getName(), colType, nullable, def);
        this.supplier.getJdbc().execute(addline);
    }

    private void checkColumnAndUpdate(ResultSet columnInfo) {
        try {
            String type;
            String colname = columnInfo.getString("COLUMN_NAME").toLowerCase();
            Column col = this.get(colname);
            switch (type = columnInfo.getString("TYPE_NAME")) {
                case "VARCHAR": 
                case "CHAR": {
                    if (col.getLength() <= columnInfo.getInt("COLUMN_SIZE")) break;
                    String fmt = "ALTER TABLE %s ALTER COLUMN %s %s(%d) ";
                    fmt = String.format(fmt, this.getName(), col.getName(), type, col.getLength());
                    this.supplier.getJdbc().execute(fmt);
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getTableConstructionInfo() {
        String rvalue = "<div>\n%s\n<div>\n<table>\n%s\n</table>\n</div>\n</div>";
        String columns = "";
        for (Column col : this) {
            String logicalName = col.getName();
            try {
                LogicalName a = this.getClass().getField(col.getJavaName()).getDeclaredAnnotation(LogicalName.class);
                if (a != null) {
                    logicalName = a.value();
                }
            }
            catch (NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
            }
            String column = "<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n";
            column = String.format(column, logicalName, col.getName(), col.getType(), col.isNullable());
            columns = columns + column;
        }
        rvalue = String.format(rvalue, this.getName(), columns);
        return rvalue;
    }

    public boolean update(Condition ... conditions) throws ClearfyDatabaseException {
        String cmd = "update %s set %s where %s";
        String tableName = this.getName();
        String fields = "";
        String wheres = "";
        for (Column column : this) {
            if (!column.hasValue()) continue;
            String field = "";
            if (!column.getType().equals(char[].class.getTypeName())) {
                field = "%s = '%s'";
                field = String.format(field, column.getFullName(), column.getValue());
            }
            fields = fields + ", " + field;
        }
        if (fields.length() <= 0) {
            throw new ClearfyDatabaseException("All Columns are not selectable on update.");
        }
        fields = fields.substring(1).trim();
        for (Condition condition : conditions) {
            String where = condition.getWhere();
            wheres = wheres + " and " + where;
        }
        if (wheres.length() > 4) {
            wheres = wheres.substring(4).trim();
        }
        cmd = String.format(cmd, tableName, fields, wheres);
        System.out.println(cmd);
        return this.supplier.getJdbc().execute(cmd);
    }

    public void clearValues() {
        for (Column column : this) {
            column.clearValue();
        }
    }

    public int getCount(Condition ... conditions) throws ClearfyDatabaseException {
        String cmdsrc = this.getSelectSentence(conditions);
        String cmd = "select count(*) reccount from (%s) countsql";
        cmd = String.format(cmd, this.getName(), cmdsrc);
        ResultSet rs = this.supplier.getJdbc().select(cmd);
        int rvalue = -1;
        try {
            if (rs.next()) {
                rvalue = rs.getInt("reccount");
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public boolean isMyColumn(Column column) {
        boolean rvalue = false;
        for (Column col : this) {
            if (!col.equals(column)) continue;
            rvalue = true;
            break;
        }
        return rvalue;
    }

    public boolean isMyColumn(String columnName) {
        boolean rvalue = false;
        for (Column col : this) {
            if (!col.getName().equals(columnName)) continue;
            rvalue = true;
            break;
        }
        return rvalue;
    }

    private boolean isAppendedColumn(String columnName) {
        columnName = columnName.toUpperCase();
        boolean rvalue = false;
        try {
            ResultSet columns = this.supplier.getJdbc().getConnection().getMetaData().getColumns(null, null, this.getName().toUpperCase(), columnName);
            if (!columns.next()) {
                rvalue = true;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public Column get(String columnName) {
        Column rvalue = null;
        for (Column col : this) {
            if (!col.getName().equals(columnName)) continue;
            rvalue = col;
            break;
        }
        return rvalue;
    }

    public ArrayList<Column> getRelationColumns() {
        ArrayList<Column> rvalue = new ArrayList<Column>();
        for (Column cols : this) {
            if (!cols.hasRelation()) continue;
            rvalue.add(cols);
        }
        return rvalue;
    }

    public Condition useJoinPath() {
        Condition rvalue = new Condition((Column)this.get(0), -2);
        return rvalue;
    }

    public void setAliasFromLogicalName(String Country) {
        Field[] fz;
        Translate translate = new Translate();
        translate.setJdbcSupplier(this.supplier);
        Class<?> myclass = this.getClass();
        for (Field field : fz = myclass.getDeclaredFields()) {
            LogicalName logicalName = field.getAnnotation(LogicalName.class);
            String fname = NameDescriptor.toSqlName(field.getName());
            String aliasName = logicalName == null ? fname : logicalName.value();
            translate.unselectAllColumn();
            ResultSet rs = translate.select(translate.TranslateData.setSelectable(true), translate.TranslateKey.sameValueOf(aliasName), translate.Language.sameValueOf(Country));
            boolean translated = false;
            try {
                if (rs.next()) {
                    aliasName = translate.TranslateData.of(rs);
                    translated = true;
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SQLException ex) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!translated) {
                translate.clearValues();
                translate.merge(translate.Language.setValue(Country), translate.TranslateKey.setValue(fname), translate.TranslateData.setValue(aliasName));
            }
            Column col = this.get(fname);
            col.setAlias(aliasName);
            System.out.println(col.getFullName());
        }
    }

    public boolean isMatched() {
        return this.matched;
    }

    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public void truncate() {
        if (this.isExist()) {
            String cmd = "truncate table %s";
            cmd = String.format(cmd, this.getName());
            System.out.println(cmd);
            this.supplier.getJdbc().execute(cmd);
        } else {
            this.alterOrCreateTable(this.supplier);
        }
    }
}

