/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.datawrapper;

import java.util.ArrayList;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Column;
import org.clearfy.datawrapper.Condition;
import org.clearfy.datawrapper.ConditionForOrder;
import org.clearfy.datawrapper.NameDescriptor;
import org.clearfy.datawrapper.RelationInfo;
import org.clearfy.datawrapper.Table;

public class SelectionDescriptor {
    public static final int MODE_ENABLE_ONLY_AUTOMATIC = 0;
    public static final int MODE_INCLUDE_DISABLE = 1;
    ArrayList<Table> tables = new ArrayList();
    private int[][] tableReference;
    private String[][] joinPattern;
    private int mode = 0;

    public String getSelectSentence(Table baseTable, Condition[] conditions) throws ClearfyDatabaseException {
        String rvalue = "select distinct %s from %s %s %s";
        String columns = "";
        String fromAndJoins = " |" + baseTable.getNameWithAlias() + "| ";
        String wheres = "";
        String orders = "";
        for (Condition condition : conditions) {
            if (condition instanceof ConditionForOrder || !condition.getColumn().getSelectable()) continue;
            Column column = condition.getColumn();
            String colName = column.getFullName();
            if (condition.getColumn().hasAlias()) {
                colName = colName + " " + condition.getColumn().getAlias();
            }
            if (columns.contains(colName)) continue;
            columns = columns + ", " + colName;
        }
        for (Column col : baseTable) {
            if (!col.getSelectable()) continue;
            String colName = col.getFullName();
            if (col.hasAlias()) {
                colName = colName + " " + col.getAlias();
            }
            if (columns.contains(colName)) continue;
            columns = columns + ", " + colName;
        }
        if (columns.length() < 1) {
            throw new ClearfyDatabaseException("no columns for selection.");
        }
        columns = columns.substring(1);
        this.tables.add(baseTable);
        String stackName = baseTable.getAlias();
        String tableNameStack = "<" + stackName + ">";
        for (Condition condition : conditions) {
            Table t = condition.getColumn().getTable();
            stackName = t.getAlias();
            if (tableNameStack.contains("<" + stackName + ">")) continue;
            this.tables.add(t);
            tableNameStack = tableNameStack + "<" + stackName + ">";
        }
        this.mapTableRelation();
        boolean res = this.checkReleation();
        if (!res) {
            throw new ClearfyDatabaseException("Unlinkd tables used at select database.");
        }
        if (res) {
            for (int i = 0; i < this.tableReference.length; ++i) {
                for (int j = 0; j < this.tableReference[i].length; ++j) {
                    if (this.tableReference[i][j] <= 0 || i == j) continue;
                    Table table = this.tables.get(i);
                    String joinTable = table.getNameWithAlias();
                    if (fromAndJoins.contains("|" + joinTable + "|")) {
                        joinTable = table.getNameWithAlias();
                    }
                    if (fromAndJoins.contains("|" + joinTable + "|")) continue;
                    switch (table.getJoinType()) {
                        case 1: {
                            fromAndJoins = fromAndJoins + "\n left join |" + joinTable + "| on \n";
                            break;
                        }
                        case 2: {
                            fromAndJoins = fromAndJoins + "\n right join |" + joinTable + "| on \n";
                            break;
                        }
                        default: {
                            fromAndJoins = fromAndJoins + "\n inner join |" + joinTable + "| on \n";
                        }
                    }
                    fromAndJoins = fromAndJoins + "\t" + this.joinPattern[i][j].substring(4) + "";
                }
            }
        }
        while (fromAndJoins.contains("$")) {
            fromAndJoins = fromAndJoins.replace("$", "");
        }
        while (fromAndJoins.contains("|")) {
            fromAndJoins = fromAndJoins.replace("|", "");
        }
        for (Condition condition : conditions) {
            if (condition instanceof ConditionForOrder) {
                String o = ((ConditionForOrder)condition).getOrder();
                if (o.trim().length() <= 0) continue;
                orders = orders + ", " + o + "\n";
                continue;
            }
            String w = condition.getWhere();
            if (w.trim().length() <= 0) continue;
            wheres = wheres + " and " + w + "\n";
        }
        if (this.mode == 0) {
            for (Table table : this.tables) {
                if (!table.isMyColumn("disable")) continue;
                wheres = wheres + " and " + table.getAlias() + ".disable = 0 \n";
            }
        }
        if (wheres.length() > 0) {
            wheres = "\nwhere " + wheres.substring(" and".length());
        }
        if (orders.length() > 0) {
            orders = "\n order by " + orders.trim().substring(",".length());
        }
        rvalue = String.format(rvalue, columns, fromAndJoins, wheres, orders);
        System.out.println(rvalue);
        return rvalue;
    }

    public boolean findRoute(Table current, Table start, Table goal) {
        boolean rvalue = false;
        ArrayList<Column> cols = current.getRelationColumns();
        for (Column column : cols) {
        }
        return rvalue;
    }

    public boolean checkReleation() {
        int i;
        boolean rvalue = true;
        if (this.tables.size() == 1) {
            return rvalue;
        }
        int[] horiz = new int[this.tables.size()];
        int[] vert = new int[this.tables.size()];
        for (i = 0; i < this.tables.size(); ++i) {
            horiz[i] = 0;
            vert[i] = 0;
        }
        for (i = 0; i < this.tables.size(); ++i) {
            for (int j = 0; j < this.tables.size(); ++j) {
                int n = i;
                horiz[n] = horiz[n] + this.tableReference[i][j];
                int n2 = i;
                vert[n2] = vert[n2] + this.tableReference[j][i];
            }
        }
        for (int i2 : horiz) {
            if (i2 >= 2) continue;
            rvalue = false;
            break;
        }
        if (rvalue) {
            for (int i2 : vert) {
                if (i2 >= 2) continue;
                rvalue = false;
                break;
            }
        }
        return rvalue;
    }

    private void joinOut() {
        System.out.println();
        for (int i = 0; i < this.tables.size(); ++i) {
            for (int j = 0; j < this.tables.size(); ++j) {
                System.out.print("[" + this.joinPattern[i][j] + "]");
            }
            System.out.println("\t" + this.tables.get(i).getName());
        }
    }

    private void mapTableRelation() {
        this.tableReference = new int[this.tables.size()][this.tables.size()];
        this.joinPattern = new String[this.tables.size()][this.tables.size()];
        if (this.tables.size() > 0) {
            int i;
            for (i = 0; i < this.tables.size(); ++i) {
                this.tables.get(i).setMatched(false);
                for (int j = 0; j < this.tables.size(); ++j) {
                    this.tableReference[i][j] = 0;
                    this.joinPattern[i][j] = "";
                }
                this.tableReference[i][i] = 1;
            }
            for (i = 0; i < this.tables.size(); ++i) {
                Table refFrom = this.tables.get(i);
                for (int j = 0; j < refFrom.size(); ++j) {
                    ArrayList col = (ArrayList)refFrom.get(j);
                    for (int k = 0; k < col.size(); ++k) {
                        String refName = NameDescriptor.toSqlName(((RelationInfo)col.get(k)).getTable().getSimpleName());
                        int l = this.getMatchedTableNumber(refName);
                        if (l <= -1) continue;
                        int[] nArray = this.tableReference[i];
                        int n = l;
                        nArray[n] = nArray[n] + 1;
                        if (i == l) continue;
                        for (Table tbl : this.tables) {
                            if (!tbl.getName().equals(refName)) continue;
                            refName = tbl.getAlias();
                            tbl.setMatched(true);
                            break;
                        }
                        Column c = (Column)col;
                        this.joinPattern[i][l] = " and $" + refFrom.getAlias() + "$." + c.getName() + " = $" + refName + "$." + c.getName();
                    }
                }
            }
            for (i = 0; i < this.tableReference.length; ++i) {
                for (int j = 0; j < this.tableReference[i].length; ++j) {
                    if (i == j || this.tableReference[i][j] <= 0 || this.tableReference[j][i] != 0) continue;
                    this.tableReference[j][i] = this.tableReference[i][j];
                    this.joinPattern[j][i] = this.joinPattern[i][j];
                }
            }
        } else {
            this.tableReference[0][0] = 0;
            this.joinPattern[0][0] = "";
        }
        this.joinOut();
    }

    private int getMatchedTableNumber(String tableName) {
        int rvalue = -1;
        for (int i = 0; i < this.tables.size(); ++i) {
            Table target = this.tables.get(i);
            if (!target.getName().equals(tableName)) continue;
            rvalue = i;
            break;
        }
        return rvalue;
    }

    private void mapOut() {
        System.out.println();
        for (int i = 0; i < this.tables.size(); ++i) {
            for (int j = 0; j < this.tables.size(); ++j) {
                System.out.print(this.tableReference[i][j]);
            }
            System.out.println("\t" + this.tables.get(i).getName());
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }
}

