/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.datawrapper;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.clearfy.datawrapper.Column;
import org.clearfy.datawrapper.Table;

public class MD5Column
extends Column<String> {
    public MD5Column() {
        this.setAllowNull(true).setLength(32).setInculdeMd5(false);
    }

    public Column calculateMD5() {
        Table table = this.getTable();
        String record = "";
        for (Column col : table) {
            if (!col.isInculdeMd5() || !col.hasValue()) continue;
            record = record + ",\"" + String.valueOf(col.getValue()) + "\"";
        }
        record = record.substring(1);
        try {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] array = record.getBytes("UTF-8");
            md5.update(array);
            byte[] bdigest = md5.digest();
            String digest = DatatypeConverter.printHexBinary((byte[])bdigest);
            this.setValue(digest);
            System.out.println(record + "\n=>" + digest);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            Logger.getLogger(MD5Column.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }
}

