/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.datawrapper;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Jdbc
implements Serializable {
    public static final int LOGGING_MODE_SILENT = 0;
    public static final int LOGGING_MODE_STDOUT = 1;
    private static final long serialVersionUID = 1L;
    private String url;
    private String user = "sa";
    private String pass = "";
    private int loggingMode = 0;

    public Jdbc(String url) {
        this.url = url;
    }

    public void setLoggingMode(int mode) {
        this.loggingMode = mode;
    }

    public int getLoggingMode() {
        return this.loggingMode;
    }

    public void setAuthInfo(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ResultSet select(String cmd) {
        this.sqlCommandLogging(cmd);
        ResultSet rvalue = null;
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            rvalue = stmt.executeQuery(cmd);
        }
        catch (SQLException ex) {
            Logger.getLogger(Jdbc.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public boolean execute(String cmd) {
        this.sqlCommandLogging(cmd);
        boolean rvalue = false;
        try (Connection connection = this.getConnection();){
            Statement stmt = connection.createStatement();
            rvalue = stmt.execute(cmd);
            stmt.close();
            connection.commit();
        }
        catch (SQLException ex) {
            Logger.getLogger(Jdbc.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public Connection getConnection() {
        return this.getConnection(this.url, this.user, this.pass);
    }

    public Connection getConnection(String jdbcUrl, String user, String password) {
        Connection rvalue = null;
        try {
            rvalue = DriverManager.getConnection(jdbcUrl, user, password);
        }
        catch (SQLException ex) {
            Logger.getLogger(Jdbc.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public boolean isExistTable(String name) {
        name = name.toUpperCase();
        boolean rvalue = false;
        try {
            DatabaseMetaData meta = this.getConnection().getMetaData();
            ResultSet rs = meta.getTables(null, null, name, new String[]{"TABLE"});
            if (rs.next()) {
                rvalue = true;
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(Jdbc.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private void sqlCommandLogging(String cmd) {
        switch (this.getLoggingMode()) {
            case 0: {
                break;
            }
            case 1: {
                System.out.println();
                System.out.println(cmd);
                System.out.println();
            }
        }
    }
}

