/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.datawrapper;

import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import org.clearfy.datawrapper.Column;

public class Condition<T> {
    public static final int SELECTABLE = -1;
    public static final int RELATION_PATH = -2;
    public static final int EQUALS = 0;
    public static final int NOT_EQUALS = 1;
    public static final int IS_NULL = 2;
    public static final int LIKE = 3;
    public static final int GREATER = 4;
    public static final int LOWER = 5;
    public static final int GREATER_EQUAL = 6;
    public static final int LOWER_EQUAL = 7;
    protected Column<T> column;
    protected int operation;
    protected Object Value;

    public Condition(Column<T> col, int operation, T value) {
        this.column = col;
        this.operation = operation;
        this.Value = value;
    }

    public Condition(Column<T> col, int operation) {
        this.column = col;
        this.operation = operation;
    }

    public String getWhere() {
        String rvalue = "%s %s %s";
        String operator = "";
        switch (this.operation) {
            case 0: {
                operator = "=";
                break;
            }
            case 1: {
                operator = "<>";
                break;
            }
            case 4: {
                operator = ">";
                break;
            }
            case 5: {
                operator = "<";
                break;
            }
            case 6: {
                operator = ">=";
                break;
            }
            case 7: {
                operator = "<=";
                break;
            }
            case 2: {
                operator = "is";
                this.Value = "null";
                break;
            }
            case 3: {
                operator = "like";
                break;
            }
            case -1: {
                this.setSelectable(true);
                return "";
            }
            case -2: {
                return "";
            }
        }
        String value = "";
        if (this.Value instanceof String) {
            value = (String)this.Value;
            if (this.column.getType().equals(String.class.getSimpleName()) || this.column.getType().equals(char[].class.getTypeName())) {
                if (value.contains("'")) {
                    value = value.replaceAll("'", "''");
                    value = String.format("'%s'", value);
                } else {
                    value = String.format("'%s'", value);
                }
            }
        } else if (this.Value instanceof Timestamp) {
            value = ((Timestamp)this.Value).toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            if (value.contains("'")) {
                value = value.replaceAll("'", "''");
                value = String.format("'%s'", value);
            }
            if (!value.contains("'")) {
                value = String.format("'%s'", value);
            }
        } else {
            value = this.Value instanceof Column ? ((Column)this.Value).getFullName() : String.valueOf(this.Value);
        }
        rvalue = String.format(rvalue, this.column.getFullName(), operator, value);
        return rvalue;
    }

    public Column<T> getColumn() {
        return this.column;
    }

    public Condition<T> setSelectable(boolean sel) {
        this.column.setSelectable(sel);
        return this;
    }

    public Condition<T> setColumnAlias(String labelText) {
        this.column.setAlias(labelText);
        return this;
    }
}

