/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.datawrapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.Condition;
import org.clearfy.datawrapper.ConditionForOrder;
import org.clearfy.datawrapper.NameDescriptor;
import org.clearfy.datawrapper.RelationInfo;
import org.clearfy.datawrapper.Table;

public class Column<T>
extends ArrayList<RelationInfo> {
    public static final int UNDEFINED_LENGTH = -1;
    public static final int DEFAULT_VARCHAR_SIZE = 32;
    public static final int DEFAULT_DECIMAL_INT_SIZE = 18;
    public static final int DEFAULT_DECIMAL_FLOAT_SIZE = 9;
    public static final String DEFAULT_TIMESTAMP = "CURRENT_TIMESTAMP";
    public static final int SIZE_2 = 2;
    public static final int SIZE_4 = 4;
    public static final int SIZE_8 = 8;
    public static final int SIZE_16 = 16;
    public static final int SIZE_32 = 32;
    public static final int SIZE_64 = 64;
    public static final int SIZE_128 = 128;
    public static final int SIZE_256 = 256;
    public static final int SIZE_512 = 512;
    public static final int SIZE_1024 = 1024;
    public static final int SIZE_2048 = 2048;
    public static final int VISIBLE_TYPE_LABEL = 0;
    public static final int VISIBLE_TYPE_TEXT = 1;
    public static final int VISIBLE_TYPE_CHECKBOX = 2;
    public static final int VISIBLE_TYPE_PASSWORD = 3;
    public static final int VISIBLE_TYPE_HIDDEN = 99;
    private String name;
    private Table myTable;
    private T value = null;
    private String typeName;
    private boolean variable = false;
    private int length = -1;
    private int floatlength = -1;
    private boolean primaryKey = false;
    private boolean nullable = true;
    private boolean autoIncrement = false;
    private boolean relation = false;
    private String defaultValue = "";
    private boolean existValue = false;
    private boolean selectable = true;
    private boolean margeTarget = true;
    private String alias = "";
    private int visibleType = 0;
    private boolean includeMd5 = true;

    public Condition setAlias(String text) {
        this.alias = text;
        return new Condition(this, -1);
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean hasAlias() {
        return this.alias.length() > 0;
    }

    public Column removeAlias() {
        this.alias = "";
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return NameDescriptor.toJavaName(this.getName());
    }

    public String getFullName() {
        String rvalue = "%s.%s";
        String colName = this.getName();
        String tableName = this.getTable().hasAlias() ? this.getTable().getAlias() : this.getTable().getName();
        rvalue = String.format(rvalue, tableName, colName);
        return rvalue;
    }

    public String getType() {
        return this.typeName;
    }

    public T getValue() {
        return this.value;
    }

    public Column setValue(T value) {
        this.value = value;
        this.existValue = true;
        return this;
    }

    public Column<T> setPrimaryKey(boolean key) {
        this.primaryKey = key;
        return this;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Column<T> setAllowNull(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Column<T> setDefault(String defaultvalue) {
        this.defaultValue = defaultvalue;
        return this;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public Column<T> setLength(int intLength, int floatLength) {
        this.length = intLength;
        this.floatlength = floatLength;
        this.variable = true;
        return this;
    }

    public Column<T> setLength(int length) {
        this.length = length;
        this.floatlength = -1;
        this.variable = true;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public int getFloatLength() {
        return this.floatlength;
    }

    public boolean isVariable() {
        return this.variable;
    }

    public String getVariableSize() {
        String fmt = "";
        fmt = this.getFloatLength() == -1 ? "(%d)" : "(%d,%d)";
        fmt = String.format(fmt, this.length, this.floatlength);
        return fmt;
    }

    public void setTable(Table table) {
        this.myTable = table;
    }

    public Table getTable() {
        return this.myTable;
    }

    public Column addRelationWith(Class<? extends Table> table) {
        return this.addRelationWith(table, this);
    }

    public Column addRelationWith(Class<? extends Table> table, Column column) {
        this.relation = false;
        if (!table.equals(this.myTable.getClass())) {
            boolean exist = false;
            for (RelationInfo inf : this) {
                if (!inf.equals(table, column)) continue;
                exist = true;
                break;
            }
            if (!exist) {
                this.add(new RelationInfo(table, column));
                this.relation = true;
            }
        }
        return this;
    }

    public boolean hasRelation() {
        return this.relation;
    }

    public Condition sameValueOf(String value) {
        Condition<String> rvalue = new Condition<String>(this, 0, value);
        return rvalue;
    }

    public Condition sameValueOf(int value) {
        Condition<String> rvalue = new Condition<String>(this, 0, String.valueOf(value));
        return rvalue;
    }

    public Condition sameValueOf(Column col) {
        Condition<Column> rvalue = new Condition<Column>(this, 0, col);
        return rvalue;
    }

    public Condition differentValueOf(String value) {
        Condition<String> rvalue = new Condition<String>(this, 1, value);
        return rvalue;
    }

    public Condition differentValueOf(Column col) {
        Condition<Column> rvalue = new Condition<Column>(this, 1, col);
        return rvalue;
    }

    public Condition isNull() {
        Condition<String> rvalue = new Condition<String>(this, 1, "");
        return rvalue;
    }

    public Condition like(String value) {
        Condition<String> rvalue = new Condition<String>(this, 3, value);
        return rvalue;
    }

    public Condition greater(String value) {
        Condition<String> rvalue = new Condition<String>(this, 4, value);
        return rvalue;
    }

    public Condition greater(Column col) {
        Condition<Column> rvalue = new Condition<Column>(this, 4, col);
        return rvalue;
    }

    public Condition greaterEqual(String value) {
        Condition<String> rvalue = new Condition<String>(this, 6, value);
        return rvalue;
    }

    public Condition greaterEqual(Column col) {
        Condition<Column> rvalue = new Condition<Column>(this, 6, col);
        return rvalue;
    }

    public Condition lower(String value) {
        Condition<String> rvalue = new Condition<String>(this, 5, value);
        return rvalue;
    }

    public Condition lower(Column col) {
        Condition<Column> rvalue = new Condition<Column>(this, 5, col);
        return rvalue;
    }

    public Condition lowerEqual(String value) {
        Condition<String> rvalue = new Condition<String>(this, 7, value);
        return rvalue;
    }

    public Condition lowerEqual(Column col) {
        Condition<Column> rvalue = new Condition<Column>(this, 7, col);
        return rvalue;
    }

    public Column setAutoIncrement(boolean setting) {
        this.autoIncrement = setting;
        return this;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void clearValue() {
        this.existValue = false;
    }

    public boolean hasValue() {
        return this.existValue;
    }

    public Condition setSelectable(boolean selectable) {
        this.selectable = selectable;
        return new Condition(this, -1);
    }

    public Condition asJoinBridge() {
        return new Condition(this, -2);
    }

    public boolean getSelectable() {
        return this.selectable;
    }

    public static Timestamp getCurrentTimestamp() {
        Timestamp rvalue = Timestamp.valueOf(LocalDateTime.now());
        return rvalue;
    }

    public T of(ResultSet rs) {
        Object rvalue = null;
        try {
            if (this.getType().equals(char[].class.getSimpleName())) {
                String sz = rs.getString(this.getName());
                return (T)sz.toCharArray();
            }
            rvalue = rs.getObject(this.getName());
        }
        catch (SQLException ex) {
            Logger.getLogger(Column.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (T)rvalue;
    }

    public Column setVisibleType(int type) {
        this.visibleType = type;
        return this;
    }

    public int getVisibleType() {
        return this.visibleType;
    }

    public ConditionForOrder asc() {
        ConditionForOrder rvalue = new ConditionForOrder(this, 100);
        return rvalue;
    }

    public ConditionForOrder desc() {
        ConditionForOrder rvalue = new ConditionForOrder(this, 101);
        return rvalue;
    }

    public boolean isInculdeMd5() {
        return this.includeMd5;
    }

    public Column setInculdeMd5(boolean include) {
        this.includeMd5 = include;
        return this;
    }

    public void setMargeTarget(boolean status) {
        this.margeTarget = status;
    }

    public boolean isMargeTarget() {
        return this.margeTarget;
    }
}

