/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.content;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfyRoles;
import org.clearfy.ClearfySection;
import org.clearfy.ClearfySession;
import org.clearfy.content.data.Content;
import org.clearfy.datawrapper.Column;
import wicket.contrib.tinymce4.TinyMceBehavior;
import wicket.contrib.tinymce4.ajax.TinyMceAjaxButton;

public class ContentView
extends ClearfySection {
    private Content content;
    private Label description;
    private AjaxLink editLink;
    private Form editForm;
    private TextField<String> titleEditor;
    private TextArea<String> richTextEditor;
    private TinyMceAjaxButton update;
    private FeedbackPanel feedback;
    private Model<String> PageClassName;
    private Model<String> SectionClassName;

    public ContentView(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.setOutputMarkupId(true);
        this.editLink = new AjaxLink("editLink", Model.of(this.getSentence("\u8aac\u660e\u306e\u7de8\u96c6"))){

            @Override
            public void onClick(AjaxRequestTarget art) {
                ContentView.this.setEditMode(true);
                art.add(ContentView.this);
            }
        };
        this.add(this.editLink);
        this.PageClassName = new Model();
        this.SectionClassName = new Model();
        this.content = new Content();
        this.content.alterOrCreateTable(this.page);
        this.PageClassName.setObject(this.page.getClass().getCanonicalName());
        this.SectionClassName.setObject(this.getClass().getCanonicalName());
        String title = "title";
        String descr = "\u8aac\u660e\u306f\u307e\u3060\u66f8\u304b\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        try {
            this.content.unselectAllColumn();
            ResultSet rs = this.content.select(this.content.Title.setSelectable(true), this.content.Description.setSelectable(true), this.content.Page.sameValueOf((String)this.PageClassName.getObject()), this.content.Section.sameValueOf((String)this.SectionClassName.getObject()));
            if (rs != null) {
                if (rs.next()) {
                    descr = this.content.Description.of(rs);
                    title = this.content.Title.of(rs);
                } else {
                    this.content.insert(this.content.Page.setValue((String)this.PageClassName.getObject()), this.content.Section.setValue((String)this.SectionClassName.getObject()), this.content.AuthorId.setValue(1), this.content.Title.setValue(title), this.content.Description.setValue(descr));
                }
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(ContentView.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.description = new Label("description", Model.of(this.getSentence(descr)));
        this.description.setEscapeModelStrings(false);
        this.description.setOutputMarkupId(true);
        this.description.setOutputMarkupPlaceholderTag(true);
        this.add(this.description);
        this.editForm = new Form("editForm");
        this.editForm.setOutputMarkupId(true);
        this.editForm.setOutputMarkupPlaceholderTag(true);
        this.titleEditor = new TextField<String>("titleEditor", (IModel<String>)Model.of(this.getSentence(this.getTitle())));
        this.titleEditor.setDefaultModelObject(this.getSentence(this.getTitle()));
        this.titleEditor.setOutputMarkupId(true);
        this.titleEditor.setOutputMarkupPlaceholderTag(true);
        this.titleEditor.setVisible(false);
        this.editForm.add(this.titleEditor);
        this.update = new TinyMceAjaxButton("update"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ContentView.this.updateDescription(target);
            }
        };
        this.update.setDefaultModel(Model.of(this.getSentence("\u66f4\u65b0")));
        this.update.setOutputMarkupId(true);
        this.update.setOutputMarkupPlaceholderTag(true);
        this.update.setVisible(false);
        this.editForm.add(this.update);
        this.richTextEditor = new TextArea<String>("richTextEditor", (IModel<String>)Model.of(descr));
        this.richTextEditor.add(new TinyMceBehavior());
        this.richTextEditor.setOutputMarkupId(true);
        this.richTextEditor.setOutputMarkupPlaceholderTag(true);
        this.richTextEditor.setVisible(false);
        this.editForm.add(this.richTextEditor);
        this.add(this.editForm);
        this.feedback = new FeedbackPanel("feedback");
        this.add(this.feedback);
        ClearfySession session = (ClearfySession)this.getSession();
        ClearfyRoles roles = (ClearfyRoles)session.getRoles();
        if (roles == null) {
            this.editLink.setVisible(false);
        } else if (!roles.hasAnyRole(new Roles(new String[]{"ADMIN", "MANAGEMENT_USER"}))) {
            this.editLink.setVisible(false);
        }
        this.setEditMode(false);
    }

    public void updateDescription(AjaxRequestTarget target) {
        ClearfySession session = (ClearfySession)this.getSession();
        int uid = Integer.valueOf(session.getUserId());
        String descriptionText = (String)this.richTextEditor.getModelObject();
        while (descriptionText.contains("\n")) {
            descriptionText = descriptionText.replace("\n", "");
        }
        while (descriptionText.contains("\r")) {
            descriptionText = descriptionText.replace("\r", "");
        }
        String titleText = (String)this.titleEditor.getModelObject();
        this.content.merge(this.content.Mdate.setValue(Column.getCurrentTimestamp()), this.content.Description.setValue(descriptionText), this.content.Title.setValue(titleText), this.content.Page.setValue((String)this.PageClassName.getObject()), this.content.Section.setValue((String)this.SectionClassName.getObject()), this.content.AuthorId.setValue(uid));
        this.description.setDefaultModelObject(descriptionText);
        this.sectionTitle.setDefaultModelObject(titleText);
        this.setEditMode(false);
        target.add(this.description);
        target.add(this.update);
        target.add(this.richTextEditor);
        target.add(this.editForm);
        target.add(this.titleEditor);
        target.add(this.sectionTitle);
    }

    public void setEditMode(boolean mode) {
        if (mode) {
            this.richTextEditor.setVisible(true);
            this.update.setVisible(true);
            this.titleEditor.setVisible(true);
            this.description.setVisible(false);
        } else {
            this.richTextEditor.setVisible(false);
            this.update.setVisible(false);
            this.description.setVisible(true);
            this.titleEditor.setVisible(false);
        }
    }

    @Override
    public String getTitle() {
        String rvalue = "";
        if (this.page == null) {
            return "";
        }
        if (this.content == null) {
            this.content = new Content();
        }
        this.content.setJdbcSupplier(this.page);
        this.PageClassName.setObject(this.page.getClass().getCanonicalName());
        this.SectionClassName.setObject(this.getClass().getCanonicalName());
        try (ResultSet rs = this.content.select(this.content.Page.sameValueOf((String)this.PageClassName.getObject()), this.content.Section.sameValueOf((String)this.SectionClassName.getObject()));){
            rvalue = rs.next() ? this.content.Title.of(rs) : "";
        }
        catch (SQLException ex) {
            Logger.getLogger(ContentView.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.getSentence(rvalue);
    }
}

