/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components.tableview;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;

public abstract class TableView
extends ClearfyContentHolder {
    private static final long serialVersionUID = 1L;
    protected Record selected;
    protected ResultSetProvider resultSetProvider;
    protected List<IColumn<Record, String>> columns;
    protected DefaultDataTable<Record, String> table;

    public TableView(String id, ClearfyPage page) {
        super(id, page);
    }

    public String getSelectedContactLabel() {
        if (this.selected == null) {
            return this.getSentence("\u30ec\u30b3\u30fc\u30c9\u304c\u3042\u308a\u307e\u305b\u3093.");
        }
        return this.selected.getField("NAME") + " " + this.selected.getField("NAME2");
    }

    public void setSelected(Record selected) {
        this.selected = selected;
    }

    @Override
    public void drawContent() {
        this.setOutputMarkupId(true);
        this.add(new FeedbackPanel("feedback"));
        this.resultSetProvider = new ResultSetProvider();
        this.columns = new ArrayList<IColumn<Record, String>>();
        this.table = new DefaultDataTable<Record, String>("datatable", this.columns, this.resultSetProvider, 30);
        this.add(this.table);
    }

    public void setItemsPerPage(long recordCount) {
        this.table.setItemsPerPage(recordCount);
    }

    public Record getRecord(int index) {
        return this.resultSetProvider.get(index);
    }

    public abstract void beforeCreateColumns(List<IColumn<Record, String>> var1);

    public abstract void afterCreateColumns(List<IColumn<Record, String>> var1);

    public abstract void defineSorter(ResultSetProvider var1);

    public List<IColumn<Record, String>> getColumns() {
        return this.columns;
    }

    public void clear() {
        this.resultSetProvider.clear();
        this.columns.clear();
    }

    public void select(String cmd) {
        this.clear();
        try {
            this.beforeCreateColumns(this.columns);
            try (ResultSet rs = this.getDataController().select(cmd);){
                ResultSetMetaData rsmeta = rs.getMetaData();
                for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                    String colName = rsmeta.getColumnLabel(i);
                    String colCaption = this.getSentence(colName);
                    PropertyColumn procol = new PropertyColumn(new Model<String>(colCaption), colName, colName);
                    this.columns.add(procol);
                }
                this.afterCreateColumns(this.columns);
                this.defineSorter(this.resultSetProvider);
                while (rs.next()) {
                    this.resultSetProvider.select(rs);
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TableView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getTitle() {
        return this.getSentence("Datatable Test.");
    }

    public abstract void onRecordSelected(AjaxRequestTarget var1, Record var2);
}

