/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components.tableview;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.SelectActionPanel;
import org.clearfy.components.tableview.TableView;

public abstract class SelectableColumn
extends AbstractColumn<Record, String> {
    private static final long serialVersionUID = 1L;
    private TableView tableView;

    public SelectableColumn(IModel<String> displayModel, String sortProperty, TableView tableView) {
        super(displayModel, sortProperty);
        this.tableView = tableView;
    }

    @Override
    public void populateItem(Item<ICellPopulator<Record>> cellItem, String componentId, IModel<Record> model) {
        final String sprop = (String)this.getSortProperty();
        cellItem.add(new SelectActionPanel(componentId, model, this.tableView){

            @Override
            public void drawContents(IModel<Record> model, final TableView parent) {
                Record record = model.getObject();
                String value = (String)record.get(sprop);
                if (value == null) {
                    value = sprop;
                }
                AjaxLink<String> select = new AjaxLink<String>("select"){
                    private static final long serialVersionUID = 1L;
                    private Record selected;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        this.selected = (Record)this.getParent().getDefaultModelObject();
                        if (parent != null) {
                            parent.setSelected(this.selected);
                        }
                        SelectableColumn.this.onSelected(target, this.selected);
                    }
                };
                Label label = new Label("selLabel", Model.of(value));
                select.add(label);
                this.add(select);
            }
        });
    }

    public abstract void onSelected(AjaxRequestTarget var1, Record var2);
}

