/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components.tableview;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.clearfy.components.tableview.Field;
import org.clearfy.components.tableview.Record;

public class ResultSetProvider
extends SortableDataProvider<Record, String> {
    private static final long serialVersionUID = 1L;
    private List<Record> list = new ArrayList<Record>();
    private SortableDataProviderComparator comparator = new SortableDataProviderComparator();

    public void select(ResultSet rs) {
        this.list.add(new Record(rs));
    }

    public void select(Field[] fields) {
        Record r = new Record(fields);
        this.list.add(r);
    }

    public void clear() {
        this.list.clear();
    }

    public Record get(int index) {
        return this.list.get(index);
    }

    @Override
    public Iterator<Record> iterator(long first, long count) {
        ArrayList<Record> newList = new ArrayList<Record>(this.list);
        Collections.sort(newList, this.comparator);
        return newList.subList((int)first, (int)(first + count)).iterator();
    }

    @Override
    public IModel<Record> model(final Record object) {
        return new AbstractReadOnlyModel<Record>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Record getObject() {
                return object;
            }
        };
    }

    @Override
    public long size() {
        return this.list.size();
    }

    class SortableDataProviderComparator
    implements Comparator<Record>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SortableDataProviderComparator() {
        }

        @Override
        public int compare(Record o1, Record o2) {
            int result = 0;
            if (ResultSetProvider.this.getSort() == null) {
                return 0;
            }
            String sortporp = (String)ResultSetProvider.this.getSort().getProperty();
            PropertyModel pm1 = new PropertyModel(o1, (String)ResultSetProvider.this.getSort().getProperty());
            PropertyModel model1 = new PropertyModel(o1, (String)ResultSetProvider.this.getSort().getProperty());
            PropertyModel model2 = new PropertyModel(o2, (String)ResultSetProvider.this.getSort().getProperty());
            String szModel1 = (String)model1.getObject();
            String szModel2 = (String)model2.getObject();
            if (szModel1 == null || szModel2 == null) {
                return 0;
            }
            result = this.isNumber(szModel1) && this.isNumber(szModel2) ? Double.valueOf(szModel1).compareTo(Double.valueOf(szModel2)) : ((Comparable)model1.getObject()).compareTo((String)model2.getObject());
            if (!ResultSetProvider.this.getSort().isAscending()) {
                result = -result;
            }
            return result;
        }

        public boolean isNumber(String num) {
            String regex = "^\\-?[0-9]*\\.?[0-9]+$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(num);
            return m.find();
        }
    }
}

