/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components.tableview;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.components.tableview.Field;
import org.clearfy.datawrapper.Column;

public class Record
extends Hashtable<String, String>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public Record(Field[] recorddata) {
        this.setFields(recorddata);
    }

    public Record(ResultSet rs) {
        try {
            ResultSetMetaData rsMeta = rs.getMetaData();
            int fieldCount = rsMeta.getColumnCount();
            Field[] fields = new Field[fieldCount];
            for (int i = 1; i <= fieldCount; ++i) {
                String value = rs.getString(i);
                if (value == null) {
                    value = "";
                }
                fields[i - 1] = new Field(rsMeta.getColumnLabel(i), value);
            }
            this.setFields(fields);
        }
        catch (SQLException ex) {
            Logger.getLogger(Record.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setFields(Field[] recorddata) {
        for (Field field : recorddata) {
            this.put(field.getKey(), field.getValue());
        }
    }

    public String getField(String key) {
        return (String)this.get(key);
    }

    public String getField(Column column) {
        String key = "";
        key = column.hasAlias() ? column.getAlias() : column.getName();
        return (String)this.get(key);
    }
}

