/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components.flexible;

import java.util.ArrayList;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.flexible.FlexColumn;

public abstract class FlexRow
extends ClearfyContentHolder {
    private int rowId = -1;
    private ArrayList<FlexColumn> columns;
    private ListView<FlexColumn> flexColumns;
    private Label flexRowHeader;
    private Image image;
    private AjaxLink flexRowPlusLink;
    private String title = "";

    public FlexRow(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.setOutputMarkupId(true);
        this.flexRowHeader = new Label("flexRowHeader", Model.of("ROW_HEADER"));
        this.add(this.flexRowHeader);
        this.flexRowPlusLink = new AjaxLink("flexRowPlusLink"){

            @Override
            public void onClick(AjaxRequestTarget target) {
                FlexRow.this.onPlusButtonClicked(target, FlexRow.this);
            }
        };
        this.flexRowPlusLink.setOutputMarkupId(true);
        this.add(this.flexRowPlusLink);
        this.columns = new ArrayList();
        this.flexColumns = new ListView<FlexColumn>("flexColumns", this.columns){

            @Override
            protected void populateItem(ListItem<FlexColumn> item) {
                FlexColumn column = item.getModelObject();
                item.add(column);
            }
        };
        this.add(this.flexColumns);
        this.image = new Image("plus", (ResourceReference)this.page.getThemeReference("plus.png"), new ResourceReference[0]);
        this.flexRowPlusLink.add(this.image);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.flexRowHeader.setDefaultModelObject(this.title);
    }

    public FlexColumn newFlexColumn() {
        FlexColumn newColumn = new FlexColumn("flexColumn", this.page);
        newColumn.setOutputMarkupId(true);
        this.columns.add(newColumn);
        return newColumn;
    }

    public void removeFlexColumn(FlexColumn column) {
        this.columns.remove(column);
    }

    public void setHeaderText(String value) {
        this.flexRowHeader.setDefaultModelObject(value);
    }

    public abstract void onPlusButtonClicked(AjaxRequestTarget var1, FlexRow var2);

    public String getCaption() {
        return this.flexRowHeader.getDefaultModelObjectAsString();
    }

    public void setRowId(int id) {
        this.rowId = id;
    }

    public int getRowId() {
        return this.rowId;
    }

    public int getFlexColumnSize() {
        return this.flexColumns.size();
    }
}

