/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ContextRelativeResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.KeyValue;

public abstract class StartEndTimePicker
extends ClearfyContentHolder {
    public static final String PROPERTY_START_TIME = "startTime";
    public static final String PROPERTY_END_TIME = "endTime";
    public static final int DATE = 0;
    public static final int DAY_OF_WEEK = 1;
    public static final int START_TIME = 2;
    public static final int END_TIME = 3;
    private TextField<String> date;
    private DropDownChoice dayOfWeeks;
    private Image saveIcon;
    private Image removeIcon;
    private TextField<String> startTime;
    private TextField<String> endTime;
    private AjaxButton minusButton;
    private AjaxButton saveButton;

    public StartEndTimePicker(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.setOutputMarkupId(true);
        this.date = new TextField<String>("date", (IModel<String>)Model.of(""));
        this.date.setOutputMarkupId(true);
        this.date.setOutputMarkupPlaceholderTag(true);
        this.add(this.date);
        ArrayList<KeyValue<String, String>> dayOfWeekList = new ArrayList<KeyValue<String, String>>();
        for (int i = 1; i <= 7; ++i) {
            KeyValue<String, String> kv = new KeyValue<String, String>(String.valueOf(i), DayOfWeek.of(i).getDisplayName(TextStyle.NARROW, this.getLocale()));
            dayOfWeekList.add(kv);
        }
        this.dayOfWeeks = new DropDownChoice<String>("dayOfWeek", (IModel<String>)Model.of(""), (List<String>)dayOfWeekList);
        this.add(this.dayOfWeeks);
        this.saveButton = new AjaxButton("saveButton", Model.of("")){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                StartEndTimePicker.this.onSaveButtonClicked(target);
            }
        };
        ContextRelativeResourceReference rr = this.page.getThemeReference("save.png");
        String ref = RequestCycle.get().urlFor(rr, new PageParameters()).toString();
        this.saveButton.add(new AttributeModifier("style", (Serializable)((Object)String.format("background-image: url('%s');", ref))));
        this.saveButton.setOutputMarkupId(true);
        this.add(this.saveButton);
        this.saveIcon = new Image("saveIcon", (ResourceReference)this.page.getThemeReference("save.png"), new ResourceReference[0]);
        this.minusButton = new AjaxButton("minusButton", Model.of("")){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                StartEndTimePicker.this.onRemoveButtonClicked(target);
            }
        };
        this.minusButton.setOutputMarkupId(true);
        rr = this.page.getThemeReference("minus.png");
        ref = RequestCycle.get().urlFor(rr, new PageParameters()).toString();
        this.minusButton.add(new AttributeModifier("style", (Serializable)((Object)String.format("background-image: url('%s');", ref))));
        this.add(this.minusButton);
        this.removeIcon = new Image("removeIcon", (ResourceReference)this.page.getThemeReference("minus.png"), new ResourceReference[0]);
        this.startTime = new TextField<String>(PROPERTY_START_TIME, (IModel<String>)Model.of(""));
        this.startTime.setOutputMarkupId(true);
        this.add(this.startTime);
        this.endTime = new TextField<String>(PROPERTY_END_TIME, (IModel<String>)Model.of(""));
        this.endTime.setOutputMarkupId(true);
        this.add(this.endTime);
    }

    public void setControlVisiblie(boolean visibility, int control) {
        switch (control) {
            case 0: {
                this.date.setVisible(visibility);
                break;
            }
            case 1: {
                this.dayOfWeeks.setVisible(visibility);
            }
        }
    }

    public void setControlValue(String value, int control) {
        switch (control) {
            case 2: {
                this.startTime.setModelObject(value);
                break;
            }
            case 3: {
                this.endTime.setModelObject(value);
            }
        }
    }

    @Override
    public String getTitle() {
        return this.getSentence("StartEndTimePicker");
    }

    @Override
    public void initializeMenu() {
    }

    public abstract void onRemoveButtonClicked(AjaxRequestTarget var1);

    public abstract void onSaveButtonClicked(AjaxRequestTarget var1);

    public String getDate() {
        String rvalue = (String)this.date.getModelObject();
        return rvalue;
    }

    public void setDate(String date) {
        this.date.setModelObject(date);
    }

    public String getDayOfWeek() {
        String rvalue = this.dayOfWeeks.getModelObject().toString();
        return rvalue;
    }

    public void setDayOfWeek(String choice) {
        this.dayOfWeeks.setModelObject(choice);
    }

    public String getStartTime() {
        return (String)this.startTime.getModelObject();
    }

    public String getEndTime() {
        return (String)this.endTime.getModelObject();
    }
}

