/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.AjaxTextField;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.components.tableview.SelectableColumn;
import org.clearfy.components.tableview.TableView;

public abstract class Selecter
extends ClearfyContentHolder {
    public static final int STATUS_LOCKED = 1;
    public static final int STATUS_UNLOCKED = 0;
    private Label selecterCaption;
    protected AjaxTextField<String> searchTextField;
    private TableView tableView;
    private Record selectedRecord;
    private boolean autoSelection = true;
    private boolean locked = false;

    public Selecter(String id, ClearfyPage page) {
        super(id, page);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean status) {
        this.locked = status;
    }

    @Override
    public void drawContent() {
        this.selecterCaption = new Label("selecterCaption", Model.of(this.getSentence(this.getLabelCaption())));
        this.add(this.selecterCaption);
        this.searchTextField = new AjaxTextField<String>("searchTextField", Model.of("")){

            @Override
            protected void onChanged(AjaxRequestTarget target) {
                Selecter.this.onSearchTextChanged(target);
            }
        };
        this.searchTextField.setOutputMarkupId(true);
        this.add(this.searchTextField);
        this.tableView = new TableView("tableView", this.page){

            @Override
            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
                Selecter.this.onBeforeCreateColumns(columns);
            }

            @Override
            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
                Selecter.this.onAfterCreateColumns(columns);
            }

            @Override
            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            @Override
            public void onRecordSelected(AjaxRequestTarget target, Record record) {
                Selecter.this.selectedRecord = record;
                Selecter.this.onSelected(target, record);
            }

            @Override
            public void initializeMenu() {
            }
        };
        this.tableView.setOutputMarkupId(true);
        this.add(this.tableView);
    }

    protected String getLabelCaption() {
        return this.getTitle();
    }

    public abstract void onSelected(AjaxRequestTarget var1, Record var2);

    protected void onBeforeCreateColumns(List<IColumn<Record, String>> columns) {
        SelectableColumn selcol = new SelectableColumn(new Model<String>(""), this.getSentence("\u9078\u629e"), this.getTableView()){

            @Override
            public void onSelected(AjaxRequestTarget target, Record selected) {
                Selecter.this.onSelected(target, selected);
            }
        };
        columns.add(selcol);
    }

    protected void onAfterCreateColumns(List<IColumn<Record, String>> columns) {
    }

    protected abstract String getSelectSentence();

    private void onSearchTextChanged(AjaxRequestTarget target) {
        if (this.isAutoSelection()) {
            String cmd = this.getSelectSentence();
            this.tableView.select(cmd);
            target.add(this.tableView);
        }
    }

    public String getSearchText() {
        return (String)this.searchTextField.getModelObject();
    }

    protected TableView getTableView() {
        return this.tableView;
    }

    public Record getSelectedRecord() {
        return this.selectedRecord;
    }

    public void setSearchText(String value) {
        this.searchTextField.setModelObject(value);
    }

    public void setSearchText(String value, AjaxRequestTarget target) {
        this.setSearchText(value);
        target.add(this.searchTextField);
    }

    @Override
    public void initializeMenu() {
    }

    public void select(AjaxRequestTarget target) {
        this.onSearchTextChanged(target);
    }

    public boolean isAutoSelection() {
        return this.autoSelection;
    }

    public void setAutoSelection(boolean autoSelection) {
        this.autoSelection = autoSelection;
    }

    public void selectAndLock(String cmd, String fieldName) {
        Record rec;
        this.tableView.select(cmd);
        this.selectedRecord = rec = this.tableView.getRecord(0);
        this.searchTextField.setModelObject(rec.getField(fieldName));
        this.searchTextField.setEnabled(false);
        this.tableView.setVisible(false);
    }
}

