/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.ISubmitter;
import org.clearfy.components.KeyValue;
import org.clearfy.components.KeyValueList;
import org.clearfy.components.SubmitPanel;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Column;
import org.clearfy.datawrapper.Condition;
import org.clearfy.datawrapper.Table;
import org.clearfy.datawrapper.Translate;

public class RelationalRadioChoice
extends ClearfyContentHolder
implements ISubmitter {
    private final Table targetTable;
    private Column keyColumn;
    private Column viewColumn;
    private RadioChoice radioChoice;
    private KeyValueList<String, String> keyValueList;
    private IChoiceRenderer<KeyValue> renderer;
    private Label formCaption;

    public RelationalRadioChoice(String id, ClearfyPage page, Table target) {
        super(id, page);
        this.targetTable = target;
        this.targetTable.setJdbcSupplier(this.page);
    }

    @Override
    public void onSubmit(AjaxRequestTarget target, SubmitPanel sources) {
    }

    public void setKeyValueColumn(Column key, Column value) throws ClearfyDatabaseException {
        if (!this.targetTable.isMyColumn(key.getName()) || !this.targetTable.isMyColumn(value.getName())) {
            throw new ClearfyDatabaseException(this.getSentence("\u30c6\u30fc\u30d6\u30eb\u306b\u542b\u307e\u308c\u306a\u3044\u30ab\u30e9\u30e0\u3092\u6307\u5b9a\u3057\u3066\u3044\u307e\u3059"));
        }
        this.keyColumn = key;
        this.keyColumn.setSelectable(true);
        this.viewColumn = value;
        this.viewColumn.setSelectable(true);
    }

    @Override
    public void drawContent() {
        this.formCaption = new Label("formCaption", (Serializable)((Object)this.getTitle()));
        this.add(this.formCaption);
        this.keyValueList = new KeyValueList();
        this.renderer = new ChoiceRenderer<KeyValue>(){

            @Override
            public Object getDisplayValue(KeyValue kvalue) {
                String rvalue = RelationalRadioChoice.this.getSentence(kvalue.getValue().toString());
                return rvalue;
            }
        };
        this.radioChoice = new RadioChoice<KeyValue>("relationalRadioChoice", (List<KeyValue>)this.keyValueList, this.renderer);
        this.radioChoice.setOutputMarkupId(true);
        this.radioChoice.setModel(Model.of(""));
        this.radioChoice.setPrefix("<div class=\"inputLine\">");
        this.radioChoice.setSuffix("</div>");
        this.add(this.radioChoice);
        this.setOutputMarkupId(true);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u30e6\u30fc\u30b6\u30fc\u6a29\u9650\u30ec\u30d9\u30eb");
    }

    @Override
    public void initializeMenu() {
    }

    public void selectList(Condition ... conditions) {
        this.keyValueList.clear();
        ResultSet res = this.targetTable.select(conditions);
        if (res != null) {
            try {
                while (res.next()) {
                    this.keyValueList.add(new KeyValue<String, String>(String.valueOf(this.keyColumn.of(res)), String.valueOf(this.viewColumn.of(res))));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(RelationalRadioChoice.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void selectListWithTranslation(Condition ... conditions) {
        Translate translate = new Translate();
        translate.setJdbcSupplier(this.page);
        this.keyValueList.clear();
        ResultSet res = this.targetTable.select(conditions);
        if (res != null) {
            try {
                while (res.next()) {
                    String viewValue = String.valueOf(this.viewColumn.of(res));
                    translate.unselectAllColumn();
                    ResultSet tres = translate.select(translate.Language.sameValueOf(this.page.getLanguage()).setSelectable(true), translate.TranslateData.sameValueOf(viewValue).setSelectable(true));
                    if (tres != null) {
                        viewValue = tres.next() ? translate.TranslateData.of(tres) : viewValue;
                    }
                    this.keyValueList.add(new KeyValue<String, String>(String.valueOf(this.keyColumn.of(res)), String.valueOf(viewValue)));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(RelationalRadioChoice.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void selectChoice(String key) {
        KeyValue kvalue = this.keyValueList.get(key);
        this.radioChoice.setModelObject(kvalue);
    }

    @Override
    public void onMerged() {
    }

    public String getSelectedKey() {
        KeyValue selitem = (KeyValue)this.radioChoice.getModelObject();
        String rvalue = "";
        for (KeyValue keyValue : this.keyValueList) {
            if (!keyValue.equals(selitem)) continue;
            rvalue = (String)keyValue.getKey();
            break;
        }
        return rvalue;
    }
}

