/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.ColumnBindedAjaxCheckBox;
import org.clearfy.components.ColumnBindedLabel;
import org.clearfy.components.ColumnBindedPassword;
import org.clearfy.components.ColumnBindedTextField;
import org.clearfy.components.IColumnBindedComponent;
import org.clearfy.components.ISubmitter;
import org.clearfy.components.SubmitPanel;
import org.clearfy.datawrapper.Column;
import org.clearfy.datawrapper.Condition;
import org.clearfy.datawrapper.Table;

public abstract class RecordEditor
extends ClearfyContentHolder
implements ISubmitter {
    private Label formCaption;
    private Table targetTable;
    private ListView<Column> columnView;
    private ArrayList<IColumnBindedComponent> columnBindedControls = new ArrayList();
    private AjaxButton recordEditorSubmit;
    private FeedbackPanel recordEditormessage;

    public RecordEditor(String id, ClearfyPage page, Table table) {
        super(id, page);
        this.targetTable = table;
        this.targetTable.setJdbcSupplier(page);
        this.drawContents();
    }

    public void clear() {
        for (Column column : this.targetTable) {
            column.setValue("");
        }
    }

    @Override
    public void drawContent() {
        this.formCaption = new Label("formCaption", Model.of(this.getTitle()));
        this.add(this.formCaption);
        this.recordEditorSubmit = new AjaxButton("recordEditorSubmit", Model.of(this.getSentence("\u66f4\u65b0"))){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                RecordEditor.this.onUpdate(target);
            }
        };
        this.add(this.recordEditorSubmit);
        this.recordEditormessage = new FeedbackPanel("recordEditorMessage");
        this.recordEditormessage.setOutputMarkupId(true);
        this.add(this.recordEditormessage);
    }

    public void drawContents() {
        this.columnView = new ListView<Column>("columns", (List)this.targetTable){

            @Override
            protected void populateItem(ListItem<Column> li) {
                Column col = li.getModelObject();
                Model<String> caption = Model.of("");
                if (col.getAlias().length() > 0) {
                    caption.setObject(col.getAlias());
                } else {
                    caption.setObject(col.getName());
                }
                Label colCaption = new Label("columnLabel", caption);
                colCaption.setOutputMarkupId(true);
                colCaption.setOutputMarkupPlaceholderTag(true);
                li.add(colCaption);
                String colValue = String.valueOf(col.getValue());
                if (colValue.equals("null")) {
                    colValue = "";
                }
                ColumnBindedLabel colValueLabel = new ColumnBindedLabel("columnValueView", Model.of(colValue));
                colValueLabel.setOutputMarkupId(true);
                colValueLabel.setOutputMarkupPlaceholderTag(true);
                li.add(colValueLabel);
                ColumnBindedTextField colValueTextField = new ColumnBindedTextField("columnValueEdit", (IModel)Model.of(colValue));
                colValueTextField.setOutputMarkupId(true);
                colValueTextField.setOutputMarkupPlaceholderTag(true);
                li.add(colValueTextField);
                ColumnBindedPassword colValuePassword = new ColumnBindedPassword("columnValuePassword", col, RecordEditor.this.page);
                colValuePassword.setOutputMarkupId(true);
                colValuePassword.setOutputMarkupPlaceholderTag(true);
                li.add(colValuePassword);
                ColumnBindedAjaxCheckBox colValueCheck = new ColumnBindedAjaxCheckBox("columnValueCheckBox", Model.of(false));
                colValueCheck.setOutputMarkupId(true);
                colValueCheck.setOutputMarkupPlaceholderTag(true);
                li.add(colValueCheck);
                this.setVisible(true);
                colValueLabel.setVisible(false);
                colValueTextField.setVisible(false);
                colValuePassword.setVisible(false);
                colValueCheck.setVisible(false);
                switch (col.getVisibleType()) {
                    case 0: {
                        colValueLabel.setVisible(true);
                        RecordEditor.this.columnBindedControls.add(colValueLabel);
                        colValueLabel.setBindedColumn(col);
                        break;
                    }
                    case 1: {
                        colValueTextField.setVisible(true);
                        colValueTextField.setBindedColumn(col);
                        RecordEditor.this.columnBindedControls.add(colValueTextField);
                        break;
                    }
                    case 3: {
                        colValuePassword.setVisible(true);
                        colValuePassword.setBindedColumn(col);
                        RecordEditor.this.columnBindedControls.add(colValuePassword);
                        break;
                    }
                    case 2: {
                        colValueCheck.setVisible(true);
                        colValueCheck.setBindedColumn(col);
                        RecordEditor.this.columnBindedControls.add(colValueCheck);
                        break;
                    }
                    case 99: {
                        li.setVisible(false);
                        colCaption.setVisible(false);
                    }
                }
            }
        };
        this.add(this.columnView);
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public void initializeMenu() {
    }

    @Override
    public void onSubmit(AjaxRequestTarget target, SubmitPanel sources) {
        this.onUpdate(target);
    }

    public void select(Condition ... conditions) {
        this.columnBindedControls.clear();
        ResultSet rs = this.targetTable.select(conditions);
        if (rs != null) {
            try {
                if (rs.next()) {
                    List<Column> cols = this.columnView.getList();
                    for (Column col : cols) {
                        col.setValue(null);
                        if (col.getVisibleType() == 99) continue;
                        String name = col.getName();
                        String data = rs.getString(name);
                        col.setValue(data);
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(RecordEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void onUpdate(AjaxRequestTarget target) {
        this.prevUpdate(target, this.targetTable);
        Column[] param = new Column[this.targetTable.size()];
        for (int i = 0; i < this.targetTable.size(); ++i) {
            param[i] = (Column)this.targetTable.get(i);
        }
        this.targetTable.merge(param);
        target.add(this.recordEditormessage);
        this.postUpdate(target, this.targetTable);
        this.info((Serializable)((Object)"\u767b\u9332\u3057\u307e\u3057\u305f\u3002"));
    }

    public IColumnBindedComponent getComponent(String columnName) {
        IColumnBindedComponent rvalue = null;
        for (IColumnBindedComponent control : this.columnBindedControls) {
            if (!control.getBindedColumn().getName().equals(columnName)) continue;
            rvalue = control;
        }
        return rvalue;
    }

    public void setColumnValue(String columnName, Object value) {
        Column column = this.targetTable.get(columnName);
        column.setValue(value);
    }

    public abstract void prevUpdate(AjaxRequestTarget var1, Table var2);

    public abstract void postUpdate(AjaxRequestTarget var1, Table var2);

    public String getValue(String columnName) {
        String rvalue = null;
        for (IColumnBindedComponent control : this.columnBindedControls) {
            if (!control.isVisible() || !control.getBindedColumn().getName().equals(columnName)) continue;
            rvalue = String.valueOf(control.getBindedColumn().getValue());
            break;
        }
        return rvalue;
    }

    public String getValue(Column column) {
        String myname = column.getName();
        return this.getValue(myname);
    }

    @Override
    public void onMerged() {
        this.recordEditorSubmit.setVisible(false);
    }
}

