/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;

public abstract class MonthPicker
extends ClearfyContentHolder {
    private ArrayList<String> yearList;
    private DropDownChoice yearSelecter;
    private ArrayList<String> monthList;
    private DropDownChoice monthSelecter;
    private Label yearmonthCaption;
    private LocalDateTime selectedYearMonth;

    public MonthPicker(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        int i;
        LocalDateTime currentTime = LocalDateTime.now();
        this.yearList = new ArrayList();
        int thisyear = currentTime.getYear();
        for (i = thisyear - 5; i <= thisyear + 5; ++i) {
            this.yearList.add(String.valueOf(i));
        }
        this.yearSelecter = new DropDownChoice<String>("year", (List<String>)this.yearList);
        this.yearSelecter.add(new AjaxFormComponentUpdatingBehavior("change"){

            @Override
            protected void onUpdate(AjaxRequestTarget target) {
                MonthPicker.this.setSelectedYearMonth();
                MonthPicker.this.onYearMonthChanged(target);
            }
        });
        this.yearSelecter.setDefaultModel(Model.of("" + thisyear));
        this.add(this.yearSelecter);
        this.monthList = new ArrayList();
        for (i = 1; i <= 12; ++i) {
            this.monthList.add(String.valueOf(i));
        }
        this.monthSelecter = new DropDownChoice<String>("month", (List<String>)this.monthList);
        this.monthSelecter.add(new AjaxFormComponentUpdatingBehavior("change"){

            @Override
            protected void onUpdate(AjaxRequestTarget target) {
                MonthPicker.this.setSelectedYearMonth();
                MonthPicker.this.onYearMonthChanged(target);
            }
        });
        int currentMonth = currentTime.getMonthValue();
        this.monthSelecter.setDefaultModel(Model.of("" + currentMonth));
        this.add(this.monthSelecter);
        this.yearmonthCaption = new Label("yearmonthCaption", Model.of(this.getSentence("\u5e74/\u6708")));
        this.add(this.yearmonthCaption);
    }

    public void setLabelCaption(String caption) {
        this.yearmonthCaption.setDefaultModelObject(this.getSentence(caption));
    }

    public void setSelectedYearMonth() {
        LocalDateTime sendvalue;
        this.selectedYearMonth = sendvalue = LocalDateTime.of((int)Integer.valueOf(this.yearSelecter.getDefaultModelObjectAsString()), Integer.valueOf(this.monthSelecter.getDefaultModelObjectAsString()), 1, 0, 0);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u5e74\u6708\u306e\u9078\u629e");
    }

    @Override
    public void initializeMenu() {
    }

    public void setYear(int year) {
        String szYear = String.valueOf(year);
        this.yearSelecter.setDefaultModelObject(szYear);
    }

    public int getYear() {
        String value = this.yearSelecter.getDefaultModelObjectAsString();
        return Integer.valueOf(value);
    }

    public void setMonth(int month) {
        String value = String.valueOf(month);
        this.monthSelecter.setDefaultModelObject(value);
    }

    public int getMonth() {
        String value = this.monthSelecter.getDefaultModelObjectAsString();
        return Integer.valueOf(value);
    }

    public abstract void onYearMonthChanged(AjaxRequestTarget var1);
}

