/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.AjaxTextField;
import org.clearfy.components.tableview.DataTableView;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.components.tableview.SelectableColumn;
import org.clearfy.datawrapper.Table;

public abstract class InOutSelecter
extends ClearfyContentHolder {
    private Label inOutSelecterCaption;
    private Label leftCaption;
    private Label rightCaption;
    private AjaxTextField<String> searchTextField;
    private DataTableView leftSelecter;
    private DataTableView rightSelecter;

    public InOutSelecter(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.inOutSelecterCaption = new Label("inOutSelecterCaption", Model.of("IN_OUT_SELECTER_CAPTION"));
        this.add(this.inOutSelecterCaption);
        this.leftCaption = new Label("leftCaption", Model.of("LEFT_CAPTION"));
        this.add(this.leftCaption);
        this.rightCaption = new Label("rightCaption", Model.of("RIGHT_CAPTION"));
        this.add(this.rightCaption);
        this.searchTextField = new AjaxTextField<String>("searchTextField", Model.of("")){

            @Override
            protected void onChanged(AjaxRequestTarget target) {
                InOutSelecter.this.onSearchFieldChanged(target);
            }
        };
        this.add(this.searchTextField);
        this.leftSelecter = new DataTableView("leftSelecter", this.page){

            @Override
            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            @Override
            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
                SelectableColumn controller = new SelectableColumn(new Model<String>(this.getSentence("")), "\u89e3\u9664", InOutSelecter.this.leftSelecter){

                    @Override
                    public void onSelected(AjaxRequestTarget target, Record selected) {
                        InOutSelecter.this.onLeftSelected(target, selected);
                    }
                };
                columns.add(controller);
            }

            @Override
            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            @Override
            public void initializeMenu() {
            }

            @Override
            public void onRecordSelected(AjaxRequestTarget target, Record record) {
            }
        };
        this.leftSelecter.setOutputMarkupId(true);
        this.add(this.leftSelecter);
        this.rightSelecter = new DataTableView("rightSelecter", this.page){

            @Override
            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            @Override
            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
                SelectableColumn controller = new SelectableColumn(new Model<String>(this.getSentence("")), "\u767b\u9332", InOutSelecter.this.leftSelecter){

                    @Override
                    public void onSelected(AjaxRequestTarget target, Record selected) {
                        InOutSelecter.this.onRightSelected(target, selected);
                    }
                };
                columns.add(controller);
            }

            @Override
            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            @Override
            public void initializeMenu() {
            }

            @Override
            public void onRecordSelected(AjaxRequestTarget target, Record record) {
            }
        };
        this.rightSelecter.setOutputMarkupId(true);
        this.add(this.rightSelecter);
    }

    public void bindLeftTable(Table leftTable) {
        this.leftSelecter.bindTable(leftTable);
    }

    public void bindRightTable(Table rightTable) {
        this.rightSelecter.bindTable(rightTable);
    }

    public String getSearchText() {
        return (String)this.searchTextField.getModelObject();
    }

    public void setSearchText(String data) {
        this.searchTextField.setModelObject(data);
    }

    public abstract void onSearchFieldChanged(AjaxRequestTarget var1);

    public void setCaption(String caption) {
        this.inOutSelecterCaption.setDefaultModelObject(caption);
    }

    public void setLeftCaption(String caption) {
        this.leftCaption.setDefaultModelObject(caption);
    }

    public void setRightCaption(String caption) {
        this.rightCaption.setDefaultModelObject(caption);
    }

    @Override
    public String getTitle() {
        return this.getSentence("InOutSelecter");
    }

    @Override
    public void initializeMenu() {
    }

    public abstract String getSelectSentenceOfLeft(String var1);

    public abstract String getSelectSentenceOfRight(String var1);

    public void select(AjaxRequestTarget target) {
        this.leftSelecter.select(this.getSelectSentenceOfLeft(this.getSearchText()));
        target.add(this.leftSelecter);
        this.rightSelecter.select(this.getSelectSentenceOfRight(this.getSearchText()));
        target.add(this.rightSelecter);
    }

    public abstract void onLeftSelected(AjaxRequestTarget var1, Record var2);

    public abstract void onRightSelected(AjaxRequestTarget var1, Record var2);

    public void setItemCountPerPage(int count) {
        this.leftSelecter.setItemsPerPage(count);
        this.rightSelecter.setItemsPerPage(count);
    }
}

