/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.PasswordCripter;
import org.clearfy.components.AjaxPasswordTextField;
import org.clearfy.components.IColumnBindedComponent;
import org.clearfy.datawrapper.Column;

public class ColumnBindedPassword
extends ClearfyContentHolder
implements IColumnBindedComponent {
    private Column bindedColumn;
    private final AjaxPasswordTextField password;
    private final Label passwordConfirmCaption;
    private final AjaxPasswordTextField passwordConfirm;

    public ColumnBindedPassword(String id, Column column, ClearfyPage page) {
        super(id, page);
        this.bindedColumn = column;
        String captionConfirm = this.page.getSentence("\uff08\u78ba\u8a8d\uff09");
        this.password = new AjaxPasswordTextField("password", Model.of("")){

            @Override
            protected void onChanged(AjaxRequestTarget target) {
                ColumnBindedPassword.this.bindedColumn.setValue(this.getValue());
            }
        };
        this.add(this.password);
        this.passwordConfirmCaption = new Label("passwordConfirmCaption", Model.of(captionConfirm));
        this.add(this.passwordConfirmCaption);
        this.passwordConfirm = new AjaxPasswordTextField("passwordConfirm", (IModel<String>)Model.of(""));
        this.add(this.passwordConfirm);
        this.setBindedColumn(column);
    }

    @Override
    public void drawContent() {
    }

    @Override
    public Column getBindedColumn() {
        return this.bindedColumn;
    }

    @Override
    public final void setBindedColumn(Column column) {
        this.bindedColumn = column;
        this.password.setModelObject("");
        this.passwordConfirm.setModelObject("");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public String getEncriptedPassword(String userAccount, String password) {
        return PasswordCripter.get(password, password);
    }

    @Override
    public Object getModelObject() {
        return this.password.getModelObject();
    }

    @Override
    public String getTitle() {
        return this.getSentence("");
    }

    @Override
    public void initializeMenu() {
    }
}

