/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.clearfy.ClearfyApplication;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfyPanel;
import org.clearfy.ClearfySession;
import org.clearfy.components.ClearfyMenu;
import org.clearfy.components.MenuBarPanel;

public class ClearfyMenuHolder
extends ClearfyPanel {
    private final ArrayList<ClearfyMenu> menusData;
    private ListView<ClearfyMenu> menuView;
    private WebMarkupContainer menuList;
    private String themePath = "";
    private ClearfyPage page;

    public ClearfyMenuHolder(String id, String panelId, ClearfyPage page) {
        super(id);
        this.page = page;
        this.menusData = new ArrayList();
        this.menuList = new WebMarkupContainer("menuList");
        this.add(this.menuList);
        ClearfySession session = (ClearfySession)this.getSession();
        String role = "";
        role = session.getRoles() == null ? "GUEST" : session.getRoles().toString();
        if (this.getDataController().isExistTable("MENU")) {
            String pageName = page.getClass().getCanonicalName();
            String cmd = "Select MENU_KEY, MENU_CAPTION_KEY, CONTENT_HOLDER_ID, ALLOW_UPPER_LEVEL, USER_AUTH_LEVEL, AUTH_ID, TARGET, SECTION ,HAS_ICON from MENU  inner join USER_AUTH on MENU.USER_AUTH_LEVEL >= USER_AUTH.AUTH_ID  where CONTENT_HOLDER_ID = '%s' and MENU.DISABLE = 0 and USER_AUTH.AUTH_TYPE = '%s'  and (PAGE_CLASS like '%s' or PAGE_CLASS = '%s') order by ORDINAL_WEIGHT, MENU_KEY ";
            cmd = String.format(cmd, panelId, role, pageName, ClearfyPage.class.getCanonicalName());
            ResultSet rs = ((ClearfyApplication)this.getApplication()).getJdbc().select(cmd);
            try {
                if (rs != null) {
                    while (rs.next()) {
                        String menuId = rs.getString("MENU_KEY");
                        String caption = rs.getString("MENU_CAPTION_KEY");
                        caption = this.getSentence(caption);
                        int menuAuthLevel = rs.getInt("USER_AUTH_LEVEL");
                        int allowUpperLevel = rs.getInt("ALLOW_UPPER_LEVEL");
                        int authId = rs.getInt("AUTH_ID");
                        if (allowUpperLevel != 1 && authId != menuAuthLevel) continue;
                        ClearfyMenu menu = new ClearfyMenu(caption, this.page){

                            @Override
                            public String getTitle() {
                                return "ClearfyMenu";
                            }
                        };
                        if (rs.getInt("HAS_ICON") == 1) {
                            menu.setHasBackGroundImage(true);
                        }
                        menu.setTarget(rs.getString("TARGET"));
                        menu.setTagId(menuId);
                        if (rs.getString("SECTION").equals("null")) {
                            menu.setSection(null);
                        } else {
                            menu.setSection(rs.getString("SECTION"));
                        }
                        this.menusData.add(menu);
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(MenuBarPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.menuView = new ListView<ClearfyMenu>("clearfyMenuView", this.menusData){

            @Override
            protected void populateItem(ListItem<ClearfyMenu> li) {
                ClearfyMenu menu = li.getModelObject();
                li.add(menu);
            }
        };
        this.menuList.add(this.menuView);
        this.menuList.add(new AttributeModifier("id", (Serializable)((Object)(panelId + "Item"))));
    }

    public void addClearfyMenu(ClearfyMenu menuItem) {
        this.menusData.add(menuItem);
    }

    @Override
    public String getTitle() {
        return "ClearfyMenuHolder";
    }
}

