/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.components;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfyPanel;
import org.clearfy.ClearfySession;

public abstract class ClearfyMenu
extends ClearfyPanel {
    public static final int ORDINAL_WEIGHT_PRIMARY = 0;
    public static final int ORDINAL_WEIGHT_APPLICATION = 100;
    public static final int ORDINAL_WEIGHT_SYSTEM_SETTING = 200;
    public static final int ORDINAL_WEIGHT_PLUGIN = 900;
    public static final int ORDINAL_WEIGHT_LAST = 999;
    private boolean _hasBackgroundImage = false;
    public static final int ALLOW_UPPER_LEVEL = 1;
    public static final int DISALLOW_UPPER_LEVEL = 0;
    private static final String CLEARFY_MENU_ID = "clearfyMenu";
    private static final String CLEARFY_MENU_LINK_ID = "clearfyMenuLink";
    private static final String CLEARFY_MENU_CAPTION_ID = "clearfyMenuCaption";
    private final AjaxLink clearfyMenuLink;
    private final Label clearfyMenuCaption;
    private final Image menuIcon;
    private String target = "";
    private String section = "";
    private String tagId = "";
    private String themePath = "";
    private ClearfyPage page;

    public ClearfyMenu(String caption, ClearfyPage page) {
        super(CLEARFY_MENU_ID);
        this.page = page;
        this.clearfyMenuLink = new AjaxLink(CLEARFY_MENU_LINK_ID){

            @Override
            public void onClick(AjaxRequestTarget art) {
                ClearfyMenu.this.onMenuClick(art);
            }
        };
        this.menuIcon = new Image("menuIcon", Model.of(""));
        this.clearfyMenuLink.add(this.menuIcon);
        this.clearfyMenuCaption = new Label(CLEARFY_MENU_CAPTION_ID, new Model<String>(caption));
        this.clearfyMenuLink.add(this.clearfyMenuCaption);
        this.add(this.clearfyMenuLink);
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public void setTagId(String id) {
        this.tagId = id;
        this.clearfyMenuCaption.add(new AttributeModifier("id", (Serializable)((Object)this.tagId)));
        if (this.hasBackgroundImage()) {
            String imgFileName = String.format("%s.png", id);
            this.menuIcon.setDefaultModelObject(this.page.getThemeReference(imgFileName));
        } else {
            this.menuIcon.setVisible(false);
        }
    }

    public boolean hasBackgroundImage() {
        return this._hasBackgroundImage;
    }

    public void setHasBackGroundImage(boolean value) {
        this._hasBackgroundImage = value;
    }

    public void onMenuClick(AjaxRequestTarget art) {
        try {
            if (this.section != null) {
                ((ClearfySession)this.getSession()).setSectionClass(Class.forName(this.section));
            } else {
                ((ClearfySession)this.getSession()).setSectionClass(null);
            }
            Class<?> target = Class.forName(this.target);
            this.setResponsePage(target);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ClearfyMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getMenuKey() {
        return this.getId();
    }

    public String getMenuCaption() {
        return this.getDefaultModelObjectAsString();
    }

    public void setThemePath(String path) {
        this.themePath = path;
    }

    public String getThemePath() {
        return this.themePath;
    }
}

