/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.users;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySession;
import org.clearfy.login.Login;
import org.clearfy.login.Logout;

public class UserPanel
extends ClearfyContentHolder {
    private Image humanIcon;
    private Image adminIcon;
    private Image logoutIcon;
    private AjaxLink logoutLink;
    private Image loginIcon;
    private AjaxLink loginLink;
    private Label userName;

    public UserPanel(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.humanIcon = new Image("humanIcon", (ResourceReference)this.page.getThemeReference("human.png"), new ResourceReference[0]);
        this.add(this.humanIcon);
        this.logoutLink = new AjaxLink("logoutLink", Model.of("")){

            @Override
            public void onClick(AjaxRequestTarget target) {
                UserPanel.this.onLogoutLinkClicked(target);
            }
        };
        this.add(this.logoutLink);
        this.logoutIcon = new Image("logoutIcon", (ResourceReference)this.page.getThemeReference("logout.png"), new ResourceReference[0]);
        this.logoutIcon.setOutputMarkupPlaceholderTag(true);
        this.logoutLink.add(this.logoutIcon);
        this.loginLink = new AjaxLink("loginLink", Model.of("")){

            @Override
            public void onClick(AjaxRequestTarget target) {
                UserPanel.this.onLoginLinkClicked(target);
            }
        };
        this.add(this.loginLink);
        this.loginIcon = new Image("loginIcon", (ResourceReference)this.page.getThemeReference("login.png"), new ResourceReference[0]);
        this.loginIcon.setOutputMarkupPlaceholderTag(true);
        this.loginLink.add(this.loginIcon);
        this.userName = new Label("userName", Model.of(this.getSentence("\u672a\u30ed\u30b0\u30a4\u30f3")));
        this.add(this.userName);
        ClearfySession session = (ClearfySession)this.getSession();
        if (session.getUserId().trim().length() > 0) {
            String userAccount = session.getUserAccount();
            this.userName.setDefaultModelObject(userAccount);
            this.loginIcon.setVisible(false);
            this.logoutIcon.setVisible(true);
        } else {
            this.loginIcon.setVisible(true);
            this.logoutIcon.setVisible(false);
        }
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u30e6\u30fc\u30b6\u30fc\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb");
    }

    private void onLoginLinkClicked(AjaxRequestTarget target) {
        this.setResponsePage(Login.class);
    }

    private void onLogoutLinkClicked(AjaxRequestTarget target) {
        this.setResponsePage(Logout.class);
    }
}

