/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.users;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.PasswordCripter;
import org.clearfy.admin.organization.data.OrganizationUserLink;
import org.clearfy.admin.users.data.User;
import org.clearfy.admin.users.data.UserAuth;
import org.clearfy.admin.users.data.UserAuthLink;
import org.clearfy.components.ISubmitter;
import org.clearfy.components.RecordEditor;
import org.clearfy.components.RelationalRadioChoice;
import org.clearfy.components.SubmitPanel;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Table;

public class NewUser
extends ClearfySection {
    public static final String SESSION_ATTR_CREATED_ID = "CREATED_ID";
    private static final long serialVersionUID = 1L;
    private Form mainForm;
    private User user;
    private RecordEditor userEditor;
    private RelationalRadioChoice authorChoice;
    private SubmitPanel submitPanel;

    public NewUser(String id, ClearfyPage pageClass) {
        super(id, pageClass);
    }

    @Override
    public void drawContent() {
        this.mainForm = new Form("mainForm");
        this.mainForm.setOutputMarkupId(true);
        this.user = new User();
        this.user.setJdbcSupplier(this.page);
        this.user.setAliasFromLogicalName(this.page.getLanguage());
        this.user.UserId.setVisibleType(99);
        this.user.Stamp.setVisibleType(0);
        this.user.Mdate.setVisibleType(0);
        this.user.Disable.setVisibleType(99);
        this.user.UserAccount.setVisibleType(1);
        this.user.UserEmail.setVisibleType(1);
        this.user.UserPasskey.setVisibleType(3);
        this.user.UserApikey.setVisibleType(0);
        this.userEditor = new RecordEditor("recordEditor", this.page, this.user){

            @Override
            public String getTitle() {
                return this.getSentence("\u7de8\u96c6\u30d5\u30a9\u30fc\u30e0");
            }

            @Override
            public void prevUpdate(AjaxRequestTarget target, Table currentTable) {
            }

            @Override
            public void postUpdate(AjaxRequestTarget target, Table currentTable) {
            }
        };
        this.userEditor.setOutputMarkupId(true);
        this.mainForm.add(this.userEditor);
        UserAuth userAuth = new UserAuth();
        userAuth.setJdbcSupplier(this.page);
        this.authorChoice = new RelationalRadioChoice("authLevelChoice", this.page, userAuth);
        try {
            this.authorChoice.setKeyValueColumn(userAuth.AuthId, userAuth.AuthType);
            this.authorChoice.selectListWithTranslation(userAuth.AuthId.asc());
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(NewUser.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.authorChoice.setDefaultModel(Model.of(""));
        this.authorChoice.setOutputMarkupId(true);
        this.mainForm.add(this.authorChoice);
        this.submitPanel = new SubmitPanel("submitPanel", this.page){

            @Override
            protected void onSubmit(AjaxRequestTarget target, ArrayList<ISubmitter> submitters) {
                NewUser.this.onSubmit(target, submitters);
            }
        };
        this.submitPanel.merge(this.userEditor);
        this.submitPanel.merge(this.authorChoice);
        this.mainForm.add(this.submitPanel);
        this.add(this.mainForm);
    }

    @Override
    public void initializeMenu() {
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u65b0\u898f\u30e6\u30fc\u30b6\u30fc\u767b\u9332");
    }

    private void onSubmit(AjaxRequestTarget target, ArrayList<ISubmitter> submitters) {
        String userAccount = this.userEditor.getValue(this.user.UserAccount);
        this.user.unselectAllColumn();
        if (this.user.getSelectCount(this.user.UserAccount.sameValueOf(userAccount).setSelectable(true)) > 0) {
            this.info((Serializable)((Object)this.getSentence("\u3059\u3067\u306b\u540c\u540d\u306e\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002")));
            target.add(this.mainForm);
        } else {
            this.user.clearValues();
            this.user.UserAccount.setValue(this.userEditor.getValue(this.user.UserAccount));
            this.user.UserEmail.setValue(this.userEditor.getValue(this.user.UserEmail));
            String passkey = PasswordCripter.get(this.user.UserAccount.getValue(), this.userEditor.getValue(this.user.UserPasskey));
            this.user.UserPasskey.setValue(passkey.toCharArray());
            this.user.UserApikey.setValue(PasswordCripter.get(this.user.UserAccount.getValue(), passkey).toCharArray());
            this.user.merge();
            ResultSet rs = this.user.select(this.user.UserPasskey.sameValueOf(String.valueOf(this.user.UserPasskey.getValue())), this.user.UserId.setSelectable(true));
            if (rs != null) {
                try {
                    int uid = rs.next() ? (Integer)this.user.UserId.of(rs) : -1;
                    int selectedAuthId = Integer.valueOf(this.authorChoice.getSelectedKey());
                    UserAuthLink userAuthLink = new UserAuthLink();
                    userAuthLink.setJdbcSupplier(this.page);
                    userAuthLink.clearValues();
                    userAuthLink.UserId.setValue(uid);
                    userAuthLink.AuthId.setValue(selectedAuthId);
                    userAuthLink.merge();
                    OrganizationUserLink organizationUserLink = new OrganizationUserLink();
                    organizationUserLink.setJdbcSupplier(this.page);
                    organizationUserLink.merge(organizationUserLink.OrganizationId.setValue(-1), organizationUserLink.UserId.setValue(uid));
                }
                catch (SQLException ex) {
                    Logger.getLogger(NewUser.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.info((Serializable)((Object)this.getSentence("\u767b\u9332\u3057\u307e\u3057\u305f\u3002")));
            this.userEditor.select(this.user.UserPasskey.sameValueOf(passkey));
            target.add(this.authorChoice);
            target.add(this.userEditor);
        }
    }
}

