/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.users;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.PasswordCripter;
import org.clearfy.admin.users.data.User;
import org.clearfy.admin.users.data.UserAuth;
import org.clearfy.admin.users.data.UserAuthLink;
import org.clearfy.components.ISubmitter;
import org.clearfy.components.RecordEditor;
import org.clearfy.components.RelationalRadioChoice;
import org.clearfy.components.Selecter;
import org.clearfy.components.SubmitPanel;
import org.clearfy.components.tableview.Record;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Table;

public class EditUser
extends ClearfySection {
    private Form editForm;
    private Selecter userSelecter;
    private FeedbackPanel feedback;
    private User user;
    private UserAuth userAuth;
    private UserAuthLink userAuthLink;
    private RecordEditor userRecordEditor;
    private RelationalRadioChoice userAuthChoice;
    private SubmitPanel submitPanel;

    public EditUser(String id, ClearfyPage pageClass) {
        super(id, pageClass);
    }

    @Override
    public void drawContent() {
        this.user = new User();
        this.user.setJdbcSupplier(this.page);
        this.userAuthLink = new UserAuthLink();
        this.userAuthLink.setJdbcSupplier(this.page);
        this.editForm = new Form("editForm");
        this.userSelecter = new Selecter("userSelecter", this.page){

            @Override
            public String getTitle() {
                return this.getSentence("\u30e6\u30fc\u30b6\u30fc\u691c\u7d22");
            }

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                EditUser.this.showSelectedUserInfo(target, record);
            }

            @Override
            protected String getSelectSentence() {
                String rvalue = null;
                try {
                    User userInselecter = new User();
                    userInselecter.setJdbcSupplier(this.page);
                    userInselecter.setAliasFromLogicalName(this.page.getLanguage());
                    userInselecter.unselectAllColumn();
                    rvalue = userInselecter.getSelectSentence(userInselecter.UserId.setSelectable(true), userInselecter.UserAccount.like("%" + (String)this.searchTextField.getModelObject() + "%").setSelectable(true), userInselecter.UserAccount.asc());
                }
                catch (ClearfyDatabaseException ex) {
                    Logger.getLogger(EditUser.class.getName()).log(Level.SEVERE, null, ex);
                }
                return rvalue;
            }
        };
        this.editForm.add(this.userSelecter);
        this.user = new User();
        this.user.setJdbcSupplier(this.page);
        this.user.setAliasFromLogicalName(this.page.getLanguage());
        this.user.UserId.setVisibleType(0);
        this.user.Stamp.setVisibleType(0);
        this.user.Mdate.setVisibleType(0);
        this.user.Disable.setVisibleType(2);
        this.user.UserPasskey.setVisibleType(3);
        this.user.UserApikey.setVisibleType(0);
        this.userRecordEditor = new RecordEditor("userRecordEditor", this.page, this.user){

            @Override
            public String getTitle() {
                return this.getSentence("\u7de8\u96c6\u30d5\u30a9\u30fc\u30e0");
            }

            @Override
            public void postUpdate(AjaxRequestTarget target, Table currentTable) {
            }

            @Override
            public void prevUpdate(AjaxRequestTarget target, Table currentTable) {
            }
        };
        this.userRecordEditor.setOutputMarkupId(true);
        this.editForm.add(this.userRecordEditor);
        this.userAuth = new UserAuth();
        this.userAuthChoice = new RelationalRadioChoice("userAuthChoice", this.page, this.userAuth);
        try {
            this.userAuthChoice.setKeyValueColumn(this.userAuth.AuthId, this.userAuth.AuthType);
            this.userAuthChoice.selectListWithTranslation(this.userAuth.AuthId.asc());
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(EditUser.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.editForm.add(this.userAuthChoice);
        this.feedback = new FeedbackPanel("feedback");
        this.feedback.setOutputMarkupId(true);
        this.editForm.add(this.feedback);
        this.submitPanel = new SubmitPanel("submitPanel", this.page){

            @Override
            protected void onSubmit(AjaxRequestTarget target, ArrayList<ISubmitter> submitters) {
                EditUser.this.onSubmit(target, submitters);
            }
        };
        this.submitPanel.merge(this.userRecordEditor);
        this.submitPanel.merge(this.userAuthChoice);
        this.editForm.add(this.submitPanel);
        this.add(this.editForm);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u30e6\u30fc\u30b6\u30fc\u60c5\u5831\u306e\u7de8\u96c6");
    }

    private void onSubmit(AjaxRequestTarget target, ArrayList<ISubmitter> submitters) {
        String userId = this.userRecordEditor.getValue(this.user.UserId);
        User usr = new User();
        usr.setJdbcSupplier(this.page);
        usr.clearValues();
        usr.UserId.setValue(Integer.valueOf(userId));
        usr.Stamp.setMargeTarget(false);
        usr.Mdate.setValue(Timestamp.valueOf(LocalDateTime.now()));
        usr.Disable.setValue(Short.valueOf(this.userRecordEditor.getValue(usr.Disable)));
        usr.UserAccount.setValue(this.userRecordEditor.getValue(usr.UserAccount));
        String passkey = PasswordCripter.get(usr.UserAccount.getValue(), this.userRecordEditor.getValue(usr.UserPasskey));
        usr.UserPasskey.setValue(passkey.toCharArray());
        usr.UserEmail.setValue(this.userRecordEditor.getValue(usr.UserEmail));
        usr.UserApikey.setValue(this.userRecordEditor.getValue(usr.UserApikey).toCharArray());
        usr.merge();
        String currentUserAuth = this.userAuthChoice.getSelectedKey();
        try {
            UserAuthLink authLink = new UserAuthLink();
            authLink.setJdbcSupplier(this.page);
            authLink.clearValues();
            authLink.unselectAllColumn();
            authLink.AuthId.setValue(Integer.valueOf(currentUserAuth));
            authLink.update(authLink.UserId.sameValueOf(userId));
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(EditUser.class.getName()).log(Level.SEVERE, null, ex);
        }
        target.add(this.feedback);
    }

    private void showSelectedUserInfo(AjaxRequestTarget target, Record record) {
        Session.get().getFeedbackMessages().clear();
        target.add(this.feedback);
        String selectedUserId = record.getField(this.user.UserId);
        this.userRecordEditor.select(this.user.UserId.sameValueOf(selectedUserId));
        target.add(this.userRecordEditor);
        ResultSet rs = this.userAuthLink.select(this.userAuthLink.UserId.sameValueOf(selectedUserId));
        if (rs != null) {
            try {
                int authId = rs.next() ? this.userAuthLink.AuthId.of(rs) : -1;
                this.userAuthChoice.selectListWithTranslation(this.userAuth.AuthId.asc());
                this.userAuthChoice.selectChoice(String.valueOf(authId));
                target.add(this.userAuthChoice);
            }
            catch (SQLException ex) {
                Logger.getLogger(EditUser.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

