/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.clearfy.ClearfyApplication;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.IInitializer;
import org.clearfy.admin.plugin.data.Plugin;

public class PluginInstallView
extends ClearfySection {
    private final Form uploadForm = new Form("uploadForm");
    private final FileUploadField fileUploadField;
    private final AjaxButton submitButton;
    private static final String UPLOAD_FOLDER = "/WEB-INF/lib/";
    private final FeedbackPanel feedback;
    private final String INSTALLER_CLASSNAME = "Initializer";

    public PluginInstallView(String id, ClearfyPage page) {
        super(id, page);
        this.uploadForm.setMultiPart(true);
        this.fileUploadField = new FileUploadField("fileUploadField");
        this.uploadForm.add(this.fileUploadField);
        this.submitButton = new AjaxButton("submitButton"){

            @Override
            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                PluginInstallView.this.fileUpload(target);
            }
        };
        this.uploadForm.add(this.submitButton);
        this.feedback = new FeedbackPanel("feedback");
        this.uploadForm.add(this.feedback);
        this.add(this.uploadForm);
    }

    @Override
    public void drawContent() {
    }

    @Override
    public String getTitle() {
        return this.getSentence("PLUGIN_INSTALL_VIEW");
    }

    public void fileUpload(AjaxRequestTarget target) {
        String uploadPath = ((ClearfyApplication)this.getApplication()).getRealPath(UPLOAD_FOLDER);
        File uploadfolder = new File(uploadPath);
        if (!uploadfolder.exists()) {
            uploadfolder.mkdir();
        }
        String pluginFile = this.fileUploadField.getFileUpload().getClientFileName();
        FileUpload fileUpload = this.fileUploadField.getFileUpload();
        if (fileUpload != null) {
            this.feedback.info((Serializable)((Object)String.format(this.getSentence("PLUGIN_FILE_UPLOADING"), pluginFile)));
            File newFile = new File(uploadPath + "/" + fileUpload.getClientFileName());
            if (newFile.exists()) {
                newFile.delete();
            }
            try {
                newFile.createNewFile();
                fileUpload.writeTo(newFile);
                fileUpload.closeStreams();
                this.feedback.info((Serializable)((Object)String.format(this.getSentence("PLUGIN_FILE_UPLOADED"), pluginFile)));
                this.installPlugin(newFile.getAbsolutePath());
            }
            catch (IOException ex) {
                Logger.getLogger(PluginInstallView.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(PluginInstallView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        target.add(this.uploadForm);
    }

    private String getResourcePathFromFilePath(String JarPath) {
        String rvalue = null;
        File f = new File(JarPath);
        int offset = (JarPath = f.getName()).lastIndexOf(".jar");
        if (offset > -1) {
            JarPath = JarPath.substring(0, offset);
        }
        if ((offset = JarPath.indexOf("-")) > -1) {
            JarPath = JarPath.substring(0, offset);
        }
        rvalue = JarPath = JarPath.replace('.', '/');
        return rvalue;
    }

    private String getInstallerClassName(String resourcePath) {
        String rvalue = null;
        rvalue = resourcePath.replace('/', '.');
        rvalue = rvalue + "." + this.INSTALLER_CLASSNAME;
        return rvalue;
    }

    public void installPlugin(String JarPath) {
        try {
            this.addClassPath(JarPath);
            String resourceName = this.getResourcePathFromFilePath(JarPath);
            String installerClass = this.getInstallerClassName(resourceName);
            URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
            Class<?> cls = cl.loadClass(installerClass);
            IInitializer pinstaller = (IInitializer)cls.newInstance();
            this.feedback.info((Serializable)((Object)String.format(this.getSentence("TARGET_PLUGIN_NAME_IS %s VER %s"), pinstaller.getPluginName(), pinstaller.getVersion())));
            Plugin plugin = new Plugin();
            plugin.setJdbcSupplier(this.page);
            plugin.PluginName.setValue(pinstaller.getPluginName());
            plugin.PluginVersion.setValue(pinstaller.getVersion());
            plugin.PluginPackage.setValue(new File(JarPath).getName());
            plugin.External.setValue((short)0);
            if (plugin.PluginPackage.getValue().contains(".jar")) {
                plugin.External.setValue((short)1);
            }
            plugin.merge();
            pinstaller.setJdbcBinder((ClearfyPage)this.getPage());
            pinstaller.initDb();
            pinstaller.registMenus();
            this.feedback.info((Serializable)((Object)String.format(this.getSentence("%s %s IS_INSTALLED"), pinstaller.getPluginName(), pinstaller.getVersion())));
            this.feedback.info((Serializable)((Object)this.getSentence("APPLICATION_RELOADING")));
            ((ClearfyApplication)this.getApplication()).getApplicationServer().reload(this.getWebPage());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(PluginInstallView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addClassPath(String path) {
        try {
            URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
            Class<URLClassLoader> loaderClass = URLClassLoader.class;
            Method method = loaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)cl, new File(path).toURI().toURL());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException ex) {
            Logger.getLogger(PluginInstallView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

