/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.IInitializer;
import org.clearfy.InitializerBase;
import org.clearfy.datawrapper.IJdbcBinder;
import org.clearfy.datawrapper.Jdbc;

public class PluginInstallUtil {
    private static final String UPLOAD_FOLDER = "/WEB-INF/lib/";
    private static final String INSTALLER_CLASSNAME = "Initializer";
    private IJdbcBinder jdbcBinder;

    public PluginInstallUtil(IJdbcBinder jdbcBinder) {
        this.jdbcBinder = jdbcBinder;
    }

    private String getResourcePathFromFilePath(String JarPath) {
        String rvalue = null;
        File f = new File(JarPath);
        int offset = (JarPath = f.getName()).lastIndexOf(".jar");
        if (offset > -1) {
            JarPath = JarPath.substring(0, offset);
        }
        if ((offset = JarPath.indexOf("-")) > -1) {
            JarPath = JarPath.substring(0, offset);
        }
        rvalue = JarPath = JarPath.replace('.', '/');
        return rvalue;
    }

    private String getInstallerClassName(String resourcePath) {
        String rvalue = resourcePath.replace('/', '.');
        rvalue = rvalue + ".Initializer";
        return rvalue;
    }

    public void installPlugin(Jdbc jdbc, String JarPath) {
        try {
            JarFile jarFile = new JarFile(JarPath);
            Enumeration<JarEntry> jarEnum = jarFile.entries();
            while (jarEnum.hasMoreElements()) {
                JarEntry jarEntry = jarEnum.nextElement();
                if (!this.isInstallerClass(jarEntry)) continue;
                String cname = this.getClassName(jarEntry.getName());
                Class<?> c = Class.forName(cname);
                IInitializer ibase = (IInitializer)c.newInstance();
                ibase.setJdbcBinder(this.jdbcBinder);
                ibase.initDb();
                ibase.registMenus();
            }
            this.addClassPath(JarPath);
            String resourceName = this.getResourcePathFromFilePath(JarPath);
            String installerClass = this.getInstallerClassName(resourceName);
            installerClass = installerClass.replace("org.clearfy.web", "org.clearfy");
            URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
            Class<?> cls = cl.loadClass(installerClass);
            IInitializer pinstaller = (IInitializer)cls.newInstance();
            pinstaller.setJdbcBinder(this.jdbcBinder);
            pinstaller.initDb();
            pinstaller.registMenus();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(PluginInstallUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(PluginInstallUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PluginInstallUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addClassPath(String path) {
        try {
            URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
            Class<URLClassLoader> loaderClass = URLClassLoader.class;
            Method method = loaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)cl, new File(path).toURI().toURL());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException ex) {
            Logger.getLogger(PluginInstallUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean isInstallerClass(JarEntry jarEntry) {
        if (!jarEntry.isDirectory() && jarEntry.getName().endsWith(".class")) {
            try {
                String cname = this.getClassName(jarEntry.getName());
                Class<?> c = Class.forName(cname);
                return this.hasIInitializerInterface(c);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(PluginInstallUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    private String getClassName(String jarPath) {
        String rvalue = jarPath.replace("/", ".");
        rvalue = rvalue.replace(".class", "");
        return rvalue;
    }

    private boolean hasIInitializerInterface(Class clazz) {
        boolean rvalue = false;
        Class sclass = clazz.getSuperclass();
        if (sclass == null) {
            rvalue = false;
        } else if (sclass.getCanonicalName().equals(InitializerBase.class.getCanonicalName())) {
            rvalue = true;
        }
        return rvalue;
    }
}

