/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.organization;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.admin.organization.OrganizationEditor;
import org.clearfy.admin.organization.OrganizationSelecter;
import org.clearfy.admin.organization.data.Organization;
import org.clearfy.components.tableview.Record;

public class SectionEdit
extends ClearfySection {
    private Form form;
    private OrganizationSelecter companySelecter;
    private OrganizationSelecter sectionSelecter;
    private OrganizationEditor organizationEditor;
    private Organization organization;
    private Model<Integer> selectedCompanyId;
    private Model<Integer> selectedSectionId;

    public SectionEdit(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.selectedCompanyId = Model.of(-1);
        this.selectedSectionId = Model.of(-1);
        this.form = new Form("form");
        this.companySelecter = this.createCompanySelecter();
        this.form.add(this.companySelecter);
        this.sectionSelecter = this.createSectionSelecter();
        this.form.add(this.sectionSelecter);
        this.organizationEditor = new OrganizationEditor("organizationEditor", this.page){

            @Override
            public void onOrganizationEditorSubmit(AjaxRequestTarget target, Form form) {
            }
        };
        this.form.add(this.organizationEditor);
        this.add(this.form);
        this.organization = new Organization();
        this.organization.setJdbcSupplier(this.page);
        this.organization.setAliasFromLogicalName(this.page.getLanguage());
    }

    private OrganizationSelecter createSectionSelecter() {
        this.sectionSelecter = new OrganizationSelecter("sectionSelecter", this.page){

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                SectionEdit.this.selectedSectionId.setObject(Integer.valueOf((String)record.get(((SectionEdit)SectionEdit.this).organization.OrganizationId.getAlias())));
                SectionEdit.this.onSectionSelected(target, record);
            }

            @Override
            public String getTitle() {
                return this.getSentence("\u90e8\u7f72\u9078\u629e");
            }

            @Override
            public int getMode() {
                return 1;
            }
        };
        this.sectionSelecter.setOutputMarkupId(true);
        return this.sectionSelecter;
    }

    private void onSectionSelected(AjaxRequestTarget target, Record record) {
        this.organizationEditor.clear();
        this.organizationEditor.loadOrganization((Integer)this.selectedSectionId.getObject());
        target.add(this.organizationEditor);
    }

    private void onCompanySelected(AjaxRequestTarget target, Record selected) {
        this.sectionSelecter.setSearchText("%");
        this.sectionSelecter.select(target);
        target.add(this.sectionSelecter);
    }

    private OrganizationSelecter createCompanySelecter() {
        this.companySelecter = new OrganizationSelecter("companySelecter", this.page){

            @Override
            public String getTitle() {
                return this.getSentence("\u4f1a\u793e\u9078\u629e");
            }

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                this.setSearchText((String)record.get(((SectionEdit)SectionEdit.this).organization.OrganizationName.getAlias()));
                target.add(this);
                SectionEdit.this.selectedCompanyId.setObject(Integer.valueOf((String)record.get(((SectionEdit)SectionEdit.this).organization.OrganizationId.getAlias())));
                SectionEdit.this.onCompanySelected(target, record);
            }

            @Override
            public int getMode() {
                return 0;
            }

            @Override
            public void onSelectAndLocked() {
                SectionEdit.this.selectedCompanyId.setObject(this.getSelectedOrganizationId());
            }
        };
        this.companySelecter.setOutputMarkupId(true);
        return this.companySelecter;
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u90e8\u7f72\u306e\u7de8\u96c6");
    }
}

