/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.organization;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.admin.organization.OrganizationSelecter;
import org.clearfy.admin.organization.data.Organization;
import org.clearfy.admin.organization.data.OrganizationUserLink;
import org.clearfy.admin.users.data.User;
import org.clearfy.components.InOutSelecter;
import org.clearfy.components.tableview.Record;
import org.clearfy.datawrapper.ClearfyDatabaseException;

public class OrganizationUserLinkEdit
extends ClearfySection {
    private static final int ITEM_PER_PAGE = 10;
    private Organization organization;
    private int selectedOrganizationId = -1;
    private OrganizationSelecter companySelecter;
    private InOutSelecter companyUserLinkSelecter;
    private User user;
    private OrganizationUserLink organizationUserLink;

    public OrganizationUserLinkEdit(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.selectedOrganizationId = 1;
        this.organization = new Organization();
        this.organization.OrganizationId.setAlias("ID");
        this.organization.OrganizationName.setAlias("\u540d\u79f0");
        this.organization.setJdbcSupplier(this.page);
        this.companySelecter = new OrganizationSelecter("companySelecter", this.page){

            @Override
            public String getTitle() {
                return OrganizationUserLinkEdit.this.getSentence("\u4f1a\u793e\u9078\u629e");
            }

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                OrganizationUserLinkEdit.this.onCompanySelected(target, record);
            }

            @Override
            public int getMode() {
                return 0;
            }
        };
        this.add(this.companySelecter);
        this.organizationUserLink = new OrganizationUserLink();
        this.user = new User();
        this.user.setJdbcSupplier(this.page);
        this.user.setAliasFromLogicalName(this.page.getLanguage());
        this.companyUserLinkSelecter = new InOutSelecter("companyUserLinkSelecter", this.page){

            @Override
            public String getSelectSentenceOfLeft(String searchText) {
                String rvalue = "";
                searchText = String.format("%%%s%%", searchText);
                OrganizationUserLinkEdit.this.user.unselectAllColumn();
                try {
                    OrganizationUserLinkEdit.this.user.unselectAllColumn();
                    rvalue = OrganizationUserLinkEdit.this.user.getSelectSentence(((OrganizationUserLinkEdit)OrganizationUserLinkEdit.this).user.UserId.setSelectable(true), ((OrganizationUserLinkEdit)OrganizationUserLinkEdit.this).user.UserAccount.like(searchText).setSelectable(true), ((OrganizationUserLinkEdit)OrganizationUserLinkEdit.this).organizationUserLink.OrganizationId.sameValueOf(String.valueOf(OrganizationUserLinkEdit.this.companySelecter.getSelectedOrganizationId())).setSelectable(false), ((OrganizationUserLinkEdit)OrganizationUserLinkEdit.this).user.UserId.asc());
                }
                catch (ClearfyDatabaseException ex) {
                    Logger.getLogger(OrganizationUserLinkEdit.class.getName()).log(Level.SEVERE, null, ex);
                }
                return rvalue;
            }

            @Override
            public String getSelectSentenceOfRight(String searchText) {
                String rvalue = "";
                searchText = String.format("%%%s%%", searchText);
                OrganizationUserLinkEdit.this.user.unselectAllColumn();
                try {
                    OrganizationUserLinkEdit.this.user.unselectAllColumn();
                    rvalue = OrganizationUserLinkEdit.this.user.getSelectSentence(((OrganizationUserLinkEdit)OrganizationUserLinkEdit.this).user.UserId.setSelectable(true), ((OrganizationUserLinkEdit)OrganizationUserLinkEdit.this).user.UserAccount.like(searchText).setSelectable(true), ((OrganizationUserLinkEdit)OrganizationUserLinkEdit.this).organizationUserLink.OrganizationId.sameValueOf("-1").setSelectable(false), ((OrganizationUserLinkEdit)OrganizationUserLinkEdit.this).user.UserId.asc());
                }
                catch (ClearfyDatabaseException ex) {
                    Logger.getLogger(OrganizationUserLinkEdit.class.getName()).log(Level.SEVERE, null, ex);
                }
                return rvalue;
            }

            @Override
            public void onLeftSelected(AjaxRequestTarget target, Record selected) {
                OrganizationUserLinkEdit.this.purgeMember(target, selected);
            }

            @Override
            public void onRightSelected(AjaxRequestTarget target, Record selected) {
                OrganizationUserLinkEdit.this.addMember(target, selected);
            }

            @Override
            public void onSearchFieldChanged(AjaxRequestTarget target) {
                this.select(target);
                target.add(this);
            }
        };
        this.companyUserLinkSelecter.setItemCountPerPage(10);
        this.companyUserLinkSelecter.setOutputMarkupId(true);
        this.companyUserLinkSelecter.setCaption(this.getSentence("\u30e1\u30f3\u30d0\u30fc\u306e\u767b\u9332/\u89e3\u9664"));
        this.companyUserLinkSelecter.setLeftCaption(this.getSentence("\u767b\u9332\u6e08\u307f\u30e1\u30f3\u30d0\u30fc"));
        this.companyUserLinkSelecter.setRightCaption(this.getSentence("\u672a\u767b\u9332\u30e1\u30f3\u30d0\u30fc"));
        this.add(this.companyUserLinkSelecter);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u4f1a\u793e\u30e1\u30f3\u30d0\u30fc\u306e\u7de8\u96c6");
    }

    private void addMember(AjaxRequestTarget target, Record selected) {
        String userId = selected.getField(this.user.UserId.getAlias());
        this.organizationUserLink.setJdbcSupplier(this.page);
        this.organizationUserLink.clearValues();
        this.organizationUserLink.OrganizationId.setValue(this.selectedOrganizationId);
        this.organizationUserLink.UserId.setValue(Integer.valueOf(userId));
        this.organizationUserLink.Mdate.setValue(Timestamp.valueOf(LocalDateTime.now()));
        try {
            this.organizationUserLink.update(this.organizationUserLink.OrganizationId.sameValueOf("-1"), this.organizationUserLink.UserId.sameValueOf(userId));
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(OrganizationUserLinkEdit.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.companyUserLinkSelecter.select(target);
    }

    private void onCompanySelected(AjaxRequestTarget target, Record record) {
        this.selectedOrganizationId = this.companySelecter.getSelectedOrganizationId();
        this.companyUserLinkSelecter.setSearchText("%");
        this.companyUserLinkSelecter.select(target);
        target.add(this.companyUserLinkSelecter);
    }

    private void purgeMember(AjaxRequestTarget target, Record selected) {
        String userId = selected.getField(this.user.UserId.getAlias());
        this.organizationUserLink.setJdbcSupplier(this.page);
        this.organizationUserLink.clearValues();
        this.organizationUserLink.OrganizationId.setValue(-1);
        this.organizationUserLink.UserId.setValue(Integer.valueOf(userId));
        this.organizationUserLink.Mdate.setValue(Timestamp.valueOf(LocalDateTime.now()));
        try {
            this.organizationUserLink.update(this.organizationUserLink.OrganizationId.sameValueOf(String.valueOf(this.selectedOrganizationId)), this.organizationUserLink.UserId.sameValueOf(userId));
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(OrganizationUserLinkEdit.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.companyUserLinkSelecter.select(target);
    }
}

