/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.organization;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.admin.organization.SectionEdit;
import org.clearfy.admin.organization.data.Organization;
import org.clearfy.components.Selecter;
import org.clearfy.components.tableview.Record;
import org.clearfy.datawrapper.ClearfyDatabaseException;

public abstract class OrganizationSelecter
extends ClearfyContentHolder {
    public static final int MODE_COMPANY_ONLY = 0;
    public static final int MODE_ORGAN_ONLY = 1;
    public static final int MODE_ALL = 2;
    public static final int INITIAL_PARENT_ID = -1;
    private Selecter selecter;
    private int currentParentId = -1;
    private Model<Integer> currentOrganizationId;
    private Organization organization;

    public OrganizationSelecter(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.currentOrganizationId = new Model<Integer>(-1);
        this.organization = new Organization();
        this.organization.setJdbcSupplier(this.page);
        this.organization.setAliasFromLogicalName(this.page.getLanguage());
        this.organization.unselectAllColumn();
        this.organization.OrganizationId.setSelectable(true);
        this.organization.OrganizationName.setSelectable(true);
        this.selecter = new Selecter("organizationSelecter", this.page){

            @Override
            public String getTitle() {
                return OrganizationSelecter.this.getTitle();
            }

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                OrganizationSelecter.this.currentOrganizationId.setObject(Integer.valueOf(record.getField(((OrganizationSelecter)OrganizationSelecter.this).organization.OrganizationId.getAlias())));
                OrganizationSelecter.this.onSelected(target, record);
            }

            @Override
            protected String getSelectSentence() {
                return OrganizationSelecter.this.getSelectSentence();
            }
        };
        if ((this.getCurrentRole().hasRole("MANAGEMENT_USER") || this.getCurrentRole().hasRole("USER")) && this.getMode() == 0) {
            int companyId = this.getCurrentUserCompany();
            try {
                this.selecter.selectAndLock(this.organization.getSelectSentence(this.organization.OrganizationId.sameValueOf(String.valueOf(companyId))), this.organization.OrganizationName.getAlias());
                this.setCurrentOrganizationId(companyId);
                this.onSelectAndLocked();
            }
            catch (ClearfyDatabaseException ex) {
                Logger.getLogger(SectionEdit.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.add(this.selecter);
    }

    public void setCurrentOrganizationId(int value) {
        this.currentOrganizationId.setObject(value);
    }

    public int getSelectedOrganizationId() {
        return (Integer)this.currentOrganizationId.getObject();
    }

    public abstract void onSelected(AjaxRequestTarget var1, Record var2);

    public abstract int getMode();

    public void select(AjaxRequestTarget target) {
        this.selecter.select(target);
    }

    public void setParentId(int id) {
        this.currentParentId = id;
    }

    public void setSearchText(String text) {
        this.selecter.setSearchText(text);
    }

    public String getSearchText() {
        return this.selecter.getSearchText();
    }

    public boolean isAutoSelection() {
        return this.selecter.isAutoSelection();
    }

    public void setAutoSelection(boolean selection) {
        this.selecter.setAutoSelection(selection);
    }

    private String getSelectSentence() {
        String rvalue = "";
        try {
            String searchValue = this.selecter.getSearchText();
            switch (this.getMode()) {
                case 2: {
                    rvalue = this.organization.getSelectSentence(this.organization.OrganizationId.setSelectable(true), this.organization.OrganizationName.like("%" + searchValue + "%").setSelectable(true));
                    break;
                }
                case 0: {
                    rvalue = this.organization.getSelectSentence(this.organization.OrganizationId.setSelectable(true), this.organization.OrganizationName.like("%" + searchValue + "%").setSelectable(true), this.organization.ParentId.sameValueOf(this.organization.OrganizationId));
                    break;
                }
                case 1: {
                    rvalue = this.currentParentId == -1 ? this.organization.getSelectSentence(this.organization.OrganizationId.setSelectable(true), this.organization.OrganizationName.like("%" + searchValue + "%").setSelectable(true), this.organization.ParentId.differentValueOf(this.organization.OrganizationId)) : this.organization.getSelectSentence(this.organization.OrganizationId.setSelectable(true), this.organization.OrganizationName.like("%" + searchValue + "%").setSelectable(true), this.organization.ParentId.sameValueOf(String.valueOf(this.organization.OrganizationId)));
                }
            }
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(OrganizationSelecter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public void onSelectAndLocked() {
    }
}

