/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.organization;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySession;
import org.clearfy.admin.organization.OrganizationListItem;

public abstract class OrganizationPicker
extends ClearfyContentHolder {
    public static final int MODE_COMPANY_SELECT = 0;
    public static final int MODE_ORGAN_SELECT = 1;
    public ArrayList<OrganizationListItem> organizationList;
    public ListView<OrganizationListItem> organizationListView;
    public WebMarkupContainer organizationListViewContainer;
    public TextField<String> searchName;
    private int mode = 1;
    private OrganizationListItem selectedOrganization;

    public OrganizationPicker(String id, ClearfyPage page) {
        super(id, page);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void drawContent() {
        this.organizationList = new ArrayList();
        this.searchName = new TextField<String>("searchName", (IModel<String>)Model.of(""));
        this.searchName.add(new AjaxFormComponentUpdatingBehavior("change"){

            @Override
            protected void onUpdate(AjaxRequestTarget target) {
                String searchString = (String)OrganizationPicker.this.searchName.getModelObject();
                OrganizationPicker.this.drawOrganizationList(searchString);
                OrganizationPicker.this.onOrganizationNameChanged(target);
                target.add(OrganizationPicker.this.organizationListViewContainer);
            }
        });
        this.add(this.searchName);
        this.organizationListViewContainer = new WebMarkupContainer("organizationListViewContainer");
        this.organizationListViewContainer.setOutputMarkupId(true);
        this.organizationListView = new ListView<OrganizationListItem>("organizationListView", this.organizationList){

            @Override
            protected void populateItem(ListItem<OrganizationListItem> item) {
                final OrganizationListItem listItem = item.getModelObject();
                AjaxLink labelItem = new AjaxLink("organizationLink"){

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        OrganizationPicker.this.setSelectedOrganization(listItem);
                        OrganizationPicker.this.onOrganizationSelected(target);
                    }
                };
                Label organizationName = new Label("organizationName", Model.of(listItem));
                labelItem.add(organizationName);
                item.add(labelItem);
            }
        };
        this.organizationListView.setOutputMarkupId(true);
        this.organizationListViewContainer.add(this.organizationListView);
        this.add(this.organizationListViewContainer);
    }

    public void onOrganizationNameChanged(AjaxRequestTarget target) {
        String searchString = (String)this.searchName.getModelObject();
        this.drawOrganizationList(searchString);
    }

    public void drawOrganizationList(String organizationName) {
        this.organizationList.clear();
        String cmd = "select ORGANIZATION_ID, ORGANIZATION_NAME, PARENT_ID from ORGANIZATION where ORGANIZATION_NAME like '%%%s%%' ";
        if (this.getCurrentRole().hasRole("MANAGEMENT_USER")) {
            String append = " and ORGANIZATION_ID in (\nSELECT ORG.ORGANIZATION_ID FROM ORGANIZATION ORG\ninner join ORGANIZATION_USER_LINK OUL on\nORG.PARENT_ID = OUL.ORGANIZATION_ID\nwhere USER_ID = %s \n)\n";
            append = String.format(append, ((ClearfySession)this.getSession()).getUserId());
            cmd = cmd + append;
        }
        if (this.mode == 0) {
            cmd = cmd + " and ORGANIZATION_ID = PARENT_ID ";
        }
        if (this.mode == 1) {
            cmd = cmd + " and ORGANIZATION_ID <> PARENT_ID ";
        }
        cmd = cmd + " and ORGANIZATION.DISABLE = 0";
        cmd = String.format(cmd, organizationName);
        ResultSet rs = this.getDataController().select(cmd);
        try {
            while (rs.next()) {
                OrganizationListItem org = new OrganizationListItem();
                org.OrganizationName = rs.getString("ORGANIZATION_NAME");
                org.OrganizationId = rs.getInt("ORGANIZATION_ID");
                org.ParentId = rs.getInt("PARENT_ID");
                this.organizationList.add(org);
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(OrganizationPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public OrganizationListItem getSelectedOrganization() {
        return this.selectedOrganization;
    }

    public void setSelectedOrganization(OrganizationListItem org) {
        this.selectedOrganization = org;
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u7d44\u7e54\u306e\u30d4\u30c3\u30af\u30a2\u30c3\u30d7");
    }

    @Override
    public void initializeMenu() {
    }

    public abstract void onOrganizationSelected(AjaxRequestTarget var1);
}

