/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.organization;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.admin.organization.data.Organization;
import org.clearfy.components.RecordEditor;
import org.clearfy.datawrapper.Table;
import org.joda.time.LocalDateTime;

public abstract class OrganizationEditor
extends ClearfyContentHolder {
    private Organization organization;
    private RecordEditor recordEditor;

    public OrganizationEditor(String id, ClearfyPage page) {
        super(id, page);
        this.setOutputMarkupId(true);
    }

    @Override
    public void drawContent() {
        Organization org = new Organization();
        org.setJdbcSupplier(this.page);
        this.organization = org;
        org.setAliasFromLogicalName(this.page.getLanguage());
        org.OrganizationId.setVisibleType(0);
        org.Stamp.setVisibleType(0);
        org.Mdate.setVisibleType(0);
        org.Disable.setVisibleType(2);
        org.ParentId.setVisibleType(0);
        this.recordEditor = new RecordEditor("recordEditor", this.page, org){

            @Override
            public String getTitle() {
                return this.getSentence("\u7de8\u96c6\u30d5\u30a9\u30fc\u30e0");
            }

            @Override
            public void prevUpdate(AjaxRequestTarget target, Table currentTable) {
                Organization org = (Organization)currentTable;
                org.Mdate.setValue(Timestamp.valueOf(LocalDateTime.now().toString("yyyy-MM-dd HH:mm:ss")));
            }

            @Override
            public void postUpdate(AjaxRequestTarget target, Table currentTable) {
                OrganizationEditor.this.onPostUpdate(target, currentTable);
            }
        };
        this.add(this.recordEditor);
    }

    public void onPostUpdate(AjaxRequestTarget target, Table currentTable) {
        Organization org = (Organization)currentTable;
        ResultSet rs = org.select(org.OrganizationName.sameValueOf(org.OrganizationName.getValue()));
        try {
            if (rs.next()) {
                if (rs.getInt(org.ParentId.getName()) == -1) {
                    org.OrganizationId.setValue(rs.getInt(org.OrganizationId.getName()));
                    org.ParentId.setValue(rs.getInt(org.OrganizationId.getName()));
                    org.merge();
                }
                this.recordEditor.select(org.OrganizationId.sameValueOf(rs.getString(org.OrganizationId.getName())));
                target.add(this);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(OrganizationEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void clear() {
        this.recordEditor.clear();
        this.getSession().getFeedbackMessages().clear();
    }

    public abstract void onOrganizationEditorSubmit(AjaxRequestTarget var1, Form var2);

    @Override
    public String getTitle() {
        return this.getSentence("\u4f01\u696d\u60c5\u5831\u7de8\u96c6");
    }

    @Override
    public void initializeMenu() {
    }

    public void loadOrganization(int orgId) {
        this.recordEditor.select(this.organization.OrganizationId.sameValueOf(String.valueOf(orgId)));
    }

    public RecordEditor getRecordEditor() {
        return this.recordEditor;
    }

    public void setColumnValue(String columnName, Object Value2) {
        this.recordEditor.setColumnValue(columnName, Value2);
    }
}

