/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.organization;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.admin.organization.OrganizationSelecter;
import org.clearfy.admin.organization.data.Organization;
import org.clearfy.admin.organization.data.OrganizationBizHours;
import org.clearfy.components.StartEndTimePicker;
import org.clearfy.components.flexible.FlexColumn;
import org.clearfy.components.flexible.FlexRow;
import org.clearfy.components.flexible.FlexTable;
import org.clearfy.components.tableview.Record;

public class OrganizationBusinessTimeEditor
extends ClearfySection {
    public static final String ATTR_DAY_OF_WEEK = "DayOfWeek";
    public static final String ATTR_ENTRY_NUMBER = "EntryNumber";
    public static final String ATTR_TARGET_SECTION = "TargetSection";
    private Form organizationBusinessTimeEditorForm;
    private OrganizationSelecter companySelecter;
    private Organization company;
    private String currentCompanyId = "";
    private OrganizationSelecter sectionSelecter;
    private Organization section;
    private FlexTable bizTimeTable;
    private Label orgNameCaption;
    private Label orgName;
    private String targetSectionId = "";

    public OrganizationBusinessTimeEditor(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.company = new Organization();
        this.company.setJdbcSupplier(this.page);
        this.company.setAliasFromLogicalName(this.page.getLanguage());
        this.section = new Organization();
        this.section.setJdbcSupplier(this.page);
        this.section.setAliasFromLogicalName(this.page.getLanguage());
        this.organizationBusinessTimeEditorForm = new Form("organizationBusinessTimeEditorForm");
        this.companySelecter = new OrganizationSelecter("companySelecter", this.page){

            @Override
            public String getTitle() {
                return this.getSentence("\u4f1a\u793e\u9078\u629e");
            }

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                OrganizationBusinessTimeEditor.this.currentCompanyId = "" + this.getSelectedOrganizationId();
                OrganizationBusinessTimeEditor.this.sectionSelecter.setSearchText("%");
                OrganizationBusinessTimeEditor.this.sectionSelecter.select(target);
            }

            @Override
            public int getMode() {
                return 0;
            }

            @Override
            public void onSelectAndLocked() {
                OrganizationBusinessTimeEditor.this.currentCompanyId = "" + this.getSelectedOrganizationId();
            }
        };
        this.organizationBusinessTimeEditorForm.add(this.companySelecter);
        this.sectionSelecter = new OrganizationSelecter("sectionSelecter", this.page){

            @Override
            public String getTitle() {
                return this.getSentence("\u90e8\u7f72\u306e\u9078\u629e");
            }

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                OrganizationBusinessTimeEditor.this.setClearfyContentAttribute(OrganizationBusinessTimeEditor.ATTR_TARGET_SECTION, record.getField(((OrganizationBusinessTimeEditor)OrganizationBusinessTimeEditor.this).section.OrganizationId.getAlias()));
                OrganizationBusinessTimeEditor.this.drawSectionBusinessTime(target, record);
            }

            @Override
            public int getMode() {
                return 1;
            }
        };
        this.organizationBusinessTimeEditorForm.add(this.sectionSelecter);
        this.bizTimeTable = new FlexTable("bizTimeTable", this.page){

            @Override
            public void onRowPlusButtonClicked(AjaxRequestTarget target, final FlexRow row) {
                final FlexColumn column = row.newFlexColumn();
                StartEndTimePicker picker = new StartEndTimePicker("flexContent", this.page){

                    @Override
                    public void onRemoveButtonClicked(AjaxRequestTarget target) {
                        OrganizationBusinessTimeEditor.this.onRemoveButtonClicked(target, this);
                        row.removeFlexColumn(column);
                        target.add(row);
                    }

                    @Override
                    public void onSaveButtonClicked(AjaxRequestTarget target) {
                        OrganizationBusinessTimeEditor.this.onSaveButtonClicked(target, this);
                    }
                };
                int entryNumber = row.getFlexColumnSize();
                picker.setClearfyContentAttribute(OrganizationBusinessTimeEditor.ATTR_ENTRY_NUMBER, entryNumber + 1);
                picker.setOutputMarkupId(true);
                picker.setClearfyContentAttribute(OrganizationBusinessTimeEditor.ATTR_DAY_OF_WEEK, row.getClearfyContentAttribute(OrganizationBusinessTimeEditor.ATTR_DAY_OF_WEEK));
                picker.setControlVisiblie(false, 0);
                picker.setControlVisiblie(false, 1);
                column.setContent(picker);
                target.add(row);
                String dayName = row.getCaption();
                System.out.println(dayName + " selected.");
            }
        };
        this.bizTimeTable.setCaption(this.getSentence("\u55b6\u696d\u6642\u9593"));
        this.organizationBusinessTimeEditorForm.add(this.bizTimeTable);
        this.orgNameCaption = new Label("orgNameCaption", Model.of(this.getSentence("\u9078\u629e\u4e2d\u306e\u90e8\u7f72")));
        this.organizationBusinessTimeEditorForm.add(this.orgNameCaption);
        this.orgName = new Label("orgName", Model.of(""));
        this.orgName.setOutputMarkupId(true);
        this.organizationBusinessTimeEditorForm.add(this.orgName);
        this.add(this.organizationBusinessTimeEditorForm);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u90e8\u7f72\u306e\u55b6\u696d\u6642\u9593\u7de8\u96c6");
    }

    public void drawSectionBusinessTime(AjaxRequestTarget target, Record record) {
        String sectionId;
        this.targetSectionId = sectionId = (String)record.get(this.section.OrganizationId.getAlias());
        String sectionName = (String)record.get(this.section.OrganizationName.getAlias());
        this.orgName.setDefaultModelObject(sectionName);
        target.add(this.orgName);
        this.bizTimeTable.clear();
        for (int dow = 1; dow < 8; ++dow) {
            FlexRow row = this.bizTimeTable.newFlexRow();
            row.setTitle(DayOfWeek.of(dow).getDisplayName(TextStyle.FULL, Locale.JAPAN));
            row.setClearfyContentAttribute(ATTR_DAY_OF_WEEK, dow);
        }
        OrganizationBizHours bizhour = new OrganizationBizHours();
        bizhour.setJdbcSupplier(this.page);
        bizhour.setAliasFromLogicalName(this.page.getLanguage());
        bizhour.unselectAllColumn();
        ResultSet rs = bizhour.select(bizhour.OrganizationId.sameValueOf(sectionId).setSelectable(true), bizhour.DayOfWeek.setSelectable(true), bizhour.EntryNum.setSelectable(true), bizhour.StartTime.setSelectable(true), bizhour.EndTime.setSelectable(true), bizhour.DayOfWeek.asc(), bizhour.EntryNum.asc());
        try {
            while (rs.next()) {
                int dow = bizhour.DayOfWeek.of(rs);
                final FlexRow row = this.bizTimeTable.getRows().get(dow - 1);
                row.setClearfyContentAttribute(ATTR_DAY_OF_WEEK, dow);
                final FlexColumn column = row.newFlexColumn();
                StartEndTimePicker picker = new StartEndTimePicker("flexContent", this.page){

                    @Override
                    public void onRemoveButtonClicked(AjaxRequestTarget target) {
                        OrganizationBusinessTimeEditor.this.onRemoveButtonClicked(target, this);
                        row.removeFlexColumn(column);
                        target.add(row);
                    }

                    @Override
                    public void onSaveButtonClicked(AjaxRequestTarget target) {
                        OrganizationBusinessTimeEditor.this.onSaveButtonClicked(target, this);
                    }
                };
                picker.setControlVisiblie(false, 0);
                picker.setControlVisiblie(false, 1);
                picker.setClearfyContentAttribute(ATTR_DAY_OF_WEEK, dow);
                int entryNumber = bizhour.EntryNum.of(rs);
                picker.setClearfyContentAttribute(ATTR_ENTRY_NUMBER, entryNumber);
                String start = bizhour.StartTime.of(rs).toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                picker.setControlValue(start, 2);
                String end = bizhour.EndTime.of(rs).toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                picker.setControlValue(end, 3);
                column.setContent(picker);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(OrganizationBusinessTimeEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        target.add(this.bizTimeTable);
    }

    public void setOrgName(String value) {
        this.orgName.setDefaultModelObject(value);
    }

    private void onRemoveButtonClicked(AjaxRequestTarget target, StartEndTimePicker picker) {
        int dow = (Integer)picker.getClearfyContentAttribute(ATTR_DAY_OF_WEEK);
        int entry = (Integer)picker.getClearfyContentAttribute(ATTR_ENTRY_NUMBER);
        OrganizationBizHours bizhours = new OrganizationBizHours();
        bizhours.setJdbcSupplier(this.page);
        bizhours.clearValues();
        bizhours.OrganizationId.setValue(Integer.valueOf((String)this.getClearfyContentAttribute(ATTR_TARGET_SECTION)));
        bizhours.DayOfWeek.setValue(dow);
        bizhours.EntryNum.setValue(entry);
        bizhours.Disable.setValue((short)1);
        bizhours.merge();
    }

    private void onSaveButtonClicked(AjaxRequestTarget target, StartEndTimePicker picker) {
        int dow = (Integer)picker.getClearfyContentAttribute(ATTR_DAY_OF_WEEK);
        String startTime = picker.getStartTime();
        String endTime = picker.getEndTime();
        int entryNum = (Integer)picker.getClearfyContentAttribute(ATTR_ENTRY_NUMBER);
        short Disable = 0;
        OrganizationBizHours bizhours = new OrganizationBizHours();
        bizhours.setJdbcSupplier(this.page);
        bizhours.OrganizationId.setValue(Integer.valueOf((String)this.getClearfyContentAttribute(ATTR_TARGET_SECTION)));
        bizhours.DayOfWeek.setValue(dow);
        bizhours.StartTime.setValue(Time.valueOf(LocalTime.parse(startTime)));
        bizhours.EndTime.setValue(Time.valueOf(LocalTime.parse(endTime)));
        bizhours.EntryNum.setValue(entryNum);
        bizhours.Disable.setValue(Disable);
        bizhours.merge();
        System.out.println(picker.toString() + " dow " + dow);
    }
}

