/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin.l10n;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.components.tableview.SelectableColumn;
import org.clearfy.components.tableview.TableView;

public class EditTranslation
extends ClearfySection {
    private ArrayList<String> langList;
    private DropDownChoice<String> langSelect;
    private Form langSelectForm;
    private TableView tableView;

    public EditTranslation(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.langSelectForm = new Form("langSelectForm");
        this.langList = new ArrayList();
        this.initLanguagList();
        this.langSelect = new DropDownChoice("langSelect", this.langList){

            @Override
            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }

            public void onSelectionChanged(Object newSelection) {
                EditTranslation.this.onLanguageSelectionChanged(newSelection);
            }
        };
        this.langSelect.setDefaultModel(Model.of(this.langList.get(0)));
        this.langSelectForm.add(this.langSelect);
        this.add(this.langSelectForm);
        this.tableView = new TableView("tableView", this.page){

            @Override
            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
                SelectableColumn selcol = new SelectableColumn(new Model<String>("Actions"), this.getSentence("\u9078\u629e"), this){

                    @Override
                    public void onSelected(AjaxRequestTarget target, Record selected) {
                        EditTranslation.this.tableView.onRecordSelected(target, selected);
                    }
                };
                columns.add(selcol);
            }

            @Override
            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            @Override
            public void defineSorter(ResultSetProvider resultSetProvider) {
                resultSetProvider.setSort(this.getSentence("TRANSLATE_KEY"), SortOrder.ASCENDING);
            }

            @Override
            public void initializeMenu() {
            }

            @Override
            public void onRecordSelected(AjaxRequestTarget target, Record record) {
                EditTranslation.this.onRecordSelected(target, record);
            }
        };
        this.tableView.setItemsPerPage(20L);
        this.add(this.tableView);
        this.onLanguageSelectionChanged(this.langSelect.getDefaultModelObject());
    }

    @Override
    public String getTitle() {
        return this.getSentence("EDIT_TRANSLATION");
    }

    public void onLanguageSelectionChanged(Object newSelection) {
        String cmd = "Select TRANSLATE_KEY,TRANSLATE_DATA from TRANSLATE where LANGUAGE = '%s' and DISABLE = 0";
        cmd = String.format(cmd, (String)newSelection);
        System.out.println(cmd);
        System.out.println("SELECT and WRITE START AT " + LocalDateTime.now().toString());
        this.tableView.select(cmd);
        System.out.println("SELECT and WRITE END AT " + LocalDateTime.now().toString());
    }

    public void initLanguagList() {
        this.langList.clear();
        String cmd = "Select LANGUAGE from TRANSLATE where DISABLE =0 group by LANGUAGE";
        ResultSet rs = this.getDataController().select(cmd);
        try {
            while (rs.next()) {
                String lang = rs.getString("LANGUAGE");
                this.langList.add(lang);
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(EditTranslation.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onRecordSelected(AjaxRequestTarget target, Record record) {
    }
}

