/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.admin;

import java.io.File;
import java.io.Serializable;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadProgressBar;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.util.resource.FileResourceStream;
import org.clearfy.ClearfyApplication;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;

public class DataBaseAdmin
extends ClearfySection {
    private Form controlForm;
    private Button downloadDatabase;
    private FileUploadField uploadField;
    private Button uploadButton;
    private UploadProgressBar progress;
    private Label dburl;

    public DataBaseAdmin(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.controlForm = new Form("controlForm");
        this.controlForm.setMultiPart(true);
        String durl = ((ClearfyApplication)this.getApplication()).getJdbcUrl();
        this.dburl = new Label("dburl", Model.of(durl));
        this.controlForm.add(this.dburl);
        this.downloadDatabase = new Button("downloadDatabase", Model.of(this.getSentence("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9"))){

            @Override
            public void onSubmit() {
                DataBaseAdmin.this.downloadDatabase();
            }
        };
        this.controlForm.add(this.downloadDatabase);
        this.uploadField = new FileUploadField("uploadField");
        this.controlForm.add(this.uploadField);
        this.uploadButton = new Button("uploadButton", Model.of(this.getSentence("\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9"))){

            @Override
            public void onSubmit() {
                DataBaseAdmin.this.uploadFile();
            }
        };
        this.controlForm.add(this.uploadButton);
        this.progress = new UploadProgressBar("progress", this.controlForm, this.uploadField);
        this.controlForm.add(this.progress);
        this.add(this.controlForm);
    }

    public void uploadFile() {
        FileUpload targetfile = this.uploadField.getFileUpload();
        ((ClearfyApplication)this.getApplication()).stopScheduler();
        ((ClearfyApplication)this.getApplication()).stopDatabase();
        if (targetfile != null) {
            File newFile = new File(this.getDatabaseFilePath());
            if (newFile.exists()) {
                newFile.delete();
            }
            try {
                newFile.createNewFile();
                targetfile.writeTo(newFile);
                this.info((Serializable)((Object)("saved file: " + targetfile.getClientFileName())));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error");
            }
        }
        ((ClearfyApplication)this.getApplication()).startDatabase();
        ((ClearfyApplication)this.getApplication()).startScheduler();
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u30c7\u30fc\u30bf\u7ba1\u7406");
    }

    @Override
    public void initializeMenu() {
    }

    public String getDatabaseFilePath() {
        String dbfile = "/WEB-INF/h2db";
        String fullPath = ((ClearfyApplication)this.getApplication()).getRealPath(dbfile);
        String fname = ((ClearfyApplication)this.getApplication()).getInitParameter("h2dbFileName");
        fullPath = fullPath + "/" + fname + ".mv.db";
        return fullPath;
    }

    public void downloadDatabase() {
        ((ClearfyApplication)this.getApplication()).stopScheduler();
        ((ClearfyApplication)this.getApplication()).stopDatabase();
        String fullPath = this.getDatabaseFilePath();
        File file = new File(fullPath);
        this.getRequestCycle().scheduleRequestHandlerAfterCurrent(new ResourceStreamRequestHandler(new FileResourceStream(file), file.getName()));
        ((ClearfyApplication)this.getApplication()).startDatabase();
        ((ClearfyApplication)this.getApplication()).startScheduler();
    }
}

