/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.clearfy.ClearfyApplication;
import org.clearfy.ClearfyRoles;
import org.clearfy.PasswordCripter;
import org.clearfy.admin.organization.data.Organization;
import org.clearfy.admin.organization.data.OrganizationUserLink;
import org.clearfy.admin.users.data.User;
import org.clearfy.admin.users.data.UserAuth;
import org.clearfy.admin.users.data.UserAuthLink;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.datawrapper.TableModifier;
import org.clearfy.login.LoginPanel;
import org.clearfy.plugin.information.InfomationSetting;

public class ClearfySession
extends AuthenticatedWebSession
implements IJdbcSupplier {
    public static final String ORGANIZATION_UNDEFINED = "-1";
    private Organization organization;
    private OrganizationUserLink organizationUserLink;
    private Roles roles;
    private User user;
    private UserAuth userAuth;
    private UserAuthLink userAuthLink;
    private String userAccount = "";
    private String userId = "";
    private String organizationId = "-1";
    private String organizationParentId = "-1";
    private Class sectionClass = InfomationSetting.class;

    public ClearfySession(Request request) {
        super(request);
    }

    public String getCurrentOrganizationId() {
        return this.organizationId;
    }

    public void setSectionClass(Class section) {
        this.sectionClass = section;
    }

    public Class getSectionClass() {
        return this.sectionClass;
    }

    public String getSectionClassName() {
        if (this.sectionClass == null) {
            return "null";
        }
        return this.sectionClass.getName();
    }

    public void removeSectionClass() {
        this.sectionClass = null;
    }

    @Override
    protected boolean authenticate(String userAccount, String password) {
        this.userAccount = userAccount;
        this.user = new User();
        this.userAuth = new UserAuth();
        this.userAuthLink = new UserAuthLink();
        this.user.setJdbcSupplier(this);
        this.organization = new Organization();
        this.organizationUserLink = new OrganizationUserLink();
        this.organization.setJdbcSupplier(this);
        this.organizationUserLink.setJdbcSupplier(this);
        boolean rvalue = false;
        String dijest = PasswordCripter.get(userAccount, password);
        String passkey = this.getUserPassKey(userAccount);
        if (dijest.equals(passkey)) {
            rvalue = true;
            TableModifier.unselectAllColumn(this.user, this.userAuth, this.userAuthLink);
            try {
                ResultSet rs = this.user.select(this.user.UserId.setSelectable(true), this.userAuth.AuthId.setSelectable(true), this.userAuth.AuthType.setSelectable(true), this.userAuthLink.useJoinPath(), this.user.UserPasskey.sameValueOf(dijest));
                this.roles = new ClearfyRoles();
                while (rs.next()) {
                    this.roles.add(this.userAuth.AuthType.of(rs));
                    this.userId = String.valueOf(this.user.UserId.of(rs));
                }
                this.organizationUserLink.unselectAllColumn();
                rs = this.organizationUserLink.select(this.organizationUserLink.OrganizationId.setSelectable(rvalue), this.organization.ParentId.setSelectable(true), this.organizationUserLink.UserId.sameValueOf(this.userId));
                if (rs != null && rs.next()) {
                    this.organizationId = String.valueOf(this.organization.OrganizationId.of(rs));
                    this.organizationParentId = String.valueOf(this.organization.ParentId.of(rs));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ClearfySession.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return rvalue;
    }

    public void setGuestMode() {
        if (this.roles == null) {
            this.roles = new ClearfyRoles();
            this.roles.add("GUEST");
        }
    }

    @Override
    public Roles getRoles() {
        return this.roles;
    }

    public String getUserId() {
        return this.userId;
    }

    private String getUserPassKey(String loginId) {
        String rvalue = "";
        if (this.user == null) {
            this.user = new User();
            this.user.setJdbcSupplier(this);
        }
        this.user.unselectAllColumn();
        try (ResultSet rs = this.user.select(this.user.UserPasskey.setSelectable(true), this.user.UserAccount.sameValueOf(loginId));){
            if (rs.next()) {
                rvalue = String.valueOf(this.user.UserPasskey.of(rs));
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(LoginPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    @Override
    public Jdbc getJdbc() {
        Jdbc rvalue = ((ClearfyApplication)this.getApplication()).getJdbc();
        return rvalue;
    }

    public String getUserAccount() {
        return this.userAccount;
    }
}

