/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ContextRelativeResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.clearfy.ClearfyApplication;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPanel;
import org.clearfy.ClearfySession;
import org.clearfy.FooterPanel;
import org.clearfy.IInitializer;
import org.clearfy.IMenuRegister;
import org.clearfy.ISentenceProvider;
import org.clearfy.InitializerBase;
import org.clearfy.admin.Admin;
import org.clearfy.admin.plugin.PluginInstallUtil;
import org.clearfy.admin.plugin.data.Plugin;
import org.clearfy.admin.users.UserPanel;
import org.clearfy.admin.users.data.User;
import org.clearfy.components.MenuBarPanel;
import org.clearfy.components.ResponsibleMenuBarPanel;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.datawrapper.Table;
import org.clearfy.index.Index;
import org.clearfy.installer.Installer;
import org.clearfy.plugin.description.Description;

public abstract class ClearfyPage
extends WebPage
implements IMenuRegister,
ISentenceProvider {
    public static final String ID_TOP_MENU = "topMenu";
    public static final String ID_SUB_MENU = "subMenu";
    private static final String APPLICATION_TITLE = "Clearfy Business";
    private static final long serialVersionUID = 1L;
    private final Image logo;
    private final Link appTitle;
    private final Label pageTitleHead;
    public ResponsibleMenuBarPanel topMenu;
    public MenuBarPanel subMenu;
    private ClearfyPanel section;
    private Label pageTitleBody;
    private final FooterPanel footerPanel;
    private final UserPanel userControl;
    private String rootPath = "";

    public ClearfyPage(PageParameters parameters) {
        super(parameters);
        this.registMenus();
        this.initPlugins();
        if (!this.isAdminRecorded()) {
            throw new RestartResponseException(Installer.class);
        }
        this.topMenu = new ResponsibleMenuBarPanel(ID_TOP_MENU, this);
        this.add(this.topMenu);
        this.subMenu = new MenuBarPanel(ID_SUB_MENU, this);
        this.add(this.subMenu);
        this.footerPanel = new FooterPanel("footerPanel");
        this.add(this.footerPanel);
        ClearfySession currentSession = (ClearfySession)this.getSession();
        this.defineInitialSection(currentSession);
        System.out.println("Section = " + currentSession.getSectionClassName());
        if (!currentSession.getSectionClassName().equals("null")) {
            try {
                this.section = (ClearfyContentHolder)Class.forName(currentSession.getSectionClassName()).getConstructor(String.class, ClearfyPage.class).newInstance("section", this);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ClearfyPage.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.section = new Description("section", this);
        }
        this.add(this.section);
        this.appTitle = new Link("appTitle", Model.of(this.getAppTitle())){

            @Override
            public void onClick() {
                ClearfyPage.this.appTitleClicked();
            }
        };
        this.logo = new Image("logo", (ResourceReference)this.getThemeReference("Logo.png"), new ResourceReference[0]);
        this.appTitle.add(this.logo);
        this.add(this.appTitle);
        this.pageTitleHead = new Label("pageTitleHead", Model.of("Clearfy Business | " + this.getPageTitle()));
        this.add(this.pageTitleHead);
        this.pageTitleBody = new Label("pageTitleBody", Model.of(this.getPageTitle()));
        this.add(this.pageTitleBody);
        this.userControl = new UserPanel("userControl", this);
        this.userControl.setOutputMarkupId(true);
        this.add(this.userControl);
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        ContextRelativeResourceReference cssFile = new ContextRelativeResourceReference(this.getThemePath("style.css"), false);
        CssReferenceHeaderItem cssItem = CssHeaderItem.forReference(cssFile);
        response.render(cssItem);
    }

    protected void defineInitialSection(ClearfySession session) {
    }

    public String getThemePath(String filename) {
        String rvalue = "WEB-INF/theme/default";
        if (this.getClass() != Installer.class) {
            try {
                String cmd = "select THEME_BASEDIR from THEME where CURRENT = 1 ";
                ResultSet rs = this.getJdbc().select(cmd);
                if (rs != null && rs.next()) {
                    rvalue = rs.getString("THEME_BASEDIR");
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ClearfyPage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return rvalue + "/" + filename;
    }

    public final ContextRelativeResourceReference getThemeReference(String filename) {
        return new ContextRelativeResourceReference(this.getThemePath(filename), false);
    }

    protected boolean isAdminRecorded() {
        boolean rvalue = true;
        try {
            User user = new User();
            user.alterOrCreateTable(this);
            user.unselectAllColumn();
            int adminCount = user.getCount(user.UserId.setSelectable(true), user.Disable.sameValueOf("0"));
            if (adminCount < 1) {
                rvalue = false;
            }
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(ClearfyPage.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public ClearfySession getCurrentSession() {
        ClearfySession session = (ClearfySession)this.getSession();
        return session;
    }

    public String getPageTitle() {
        return APPLICATION_TITLE;
    }

    public ClearfyApplication getClearfyApplication() {
        return (ClearfyApplication)super.getApplication();
    }

    public String getAppTitle() {
        return APPLICATION_TITLE;
    }

    public void appTitleClicked() {
        this.setResponsePage(((ClearfyApplication)this.getApplication()).getHomePage());
    }

    @Override
    public Jdbc getJdbc() {
        return ((ClearfyApplication)this.getApplication()).getJdbc();
    }

    @Override
    public String getSentence(String sentenceKey) {
        String rvalue = ((ClearfyApplication)this.getApplication()).getSentence(sentenceKey);
        return rvalue;
    }

    public void registMenus() {
        if (this.getJdbc().isExistTable("MENU")) {
            this.registMenu("index", "\u30db\u30fc\u30e0", 0, ID_TOP_MENU, ClearfyPage.class, 5, 1, Index.class, null, true);
            this.registMenu("admin", "\u7ba1\u7406", 200, ID_TOP_MENU, ClearfyPage.class, 3, 1, Admin.class, null, true);
        }
    }

    @Override
    public void registMenu(String MenuId, String MenuCaptionKey, int ordinal, String contentHolderId, Class pageClass, int AuthLevel, int allowUpperLevel, Class targetClass, Class sectionClass, boolean hasMenuImage) {
        this.getClearfyApplication().registMenu(MenuId, MenuCaptionKey, ordinal, contentHolderId, pageClass, AuthLevel, allowUpperLevel, targetClass, sectionClass, hasMenuImage);
    }

    @Override
    public void registMenu(String MenuId, String MenuCaptionKey, int ordinal, String contentHolderId, Class pageClass, int AuthLevel, int allowUpperLevel, Class targetClass, Class sectionClass) {
        this.getClearfyApplication().registMenu(MenuId, MenuCaptionKey, ordinal, contentHolderId, pageClass, AuthLevel, allowUpperLevel, targetClass, sectionClass);
    }

    private void initPlugins() {
        if (((ClearfyApplication)this.getApplication()).isInitialized()) {
            return;
        }
        System.out.println("======= \u7d44\u307f\u8fbc\u307f\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u691c\u51fa\u3068\u521d\u671f\u5316 ======");
        this.rootPath = ((ClearfyApplication)this.getApplication()).getRealPath("/WEB-INF/classes");
        File f = new File(this.rootPath);
        this.checkTables(f);
        this.checkInitDatas(f);
        System.out.println("======= \u3053\u3053\u307e\u3067 ======");
        System.out.println();
        System.out.println("======= \u5916\u90e8\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u691c\u51fa\u3068\u521d\u671f\u5316 ======");
        Plugin plugin = new Plugin();
        plugin.setJdbcSupplier(this);
        ResultSet rs = plugin.select(plugin.External.sameValueOf("1"));
        if (rs != null) {
            try {
                PluginInstallUtil util = new PluginInstallUtil(this);
                while (rs.next()) {
                    String fname = plugin.PluginPackage.of(rs);
                    fname = this.getClearfyApplication().getRealPath("/WEB-INF/lib/" + fname);
                    System.out.println(fname);
                    util.installPlugin(this.getJdbc(), fname);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ClearfyPage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println("======= \u3053\u3053\u307e\u3067 ======");
        ((ClearfyApplication)this.getApplication()).setInitialized(true);
    }

    private boolean checkInitDatas(File f) {
        File[] children;
        boolean rvalue = false;
        for (File child : children = f.listFiles()) {
            if (child.isDirectory()) {
                this.checkInitDatas(child);
                continue;
            }
            if (!child.getName().endsWith(".class")) continue;
            String cname = child.getAbsolutePath();
            cname = cname.substring(this.rootPath.length() + 1);
            cname = cname.replace(File.separator, ".");
            cname = cname.replace(".class", "");
            this.mergeInitDatas(cname);
        }
        return rvalue;
    }

    private void mergeInitDatas(String cname) {
        try {
            Class<?> cls = Class.forName(cname);
            if (cls.getName().equals(InitializerBase.class.getName())) {
                return;
            }
            boolean match = false;
            if (cls.getSuperclass() != null && cls.getSuperclass().getName().equals(InitializerBase.class.getName())) {
                match = true;
            }
            if (!match) {
                Class<?>[] infs;
                for (Class<?> inf : infs = cls.getInterfaces()) {
                    if (!inf.getName().equals(IInitializer.class.getName())) continue;
                    match = true;
                    break;
                }
            }
            if (match) {
                IInitializer ipins = (IInitializer)cls.newInstance();
                ipins.setJdbcBinder(this);
                ipins.initDb();
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "*** merge init datas *** " + cname);
                ipins.registMenus();
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "*** menu registration *** " + cname);
                Plugin plugin = new Plugin();
                plugin.setJdbcSupplier(ipins);
                plugin.merge(plugin.PluginPackage.setValue(ipins.getPluginName()), plugin.PluginName.setValue(ipins.getPluginName()), plugin.PluginVersion.setValue(ipins.getVersion()), plugin.Mdate.setValue(Timestamp.valueOf(LocalDateTime.now())), plugin.Disable.setValue((short)0));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(ClearfyPage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean checkTables(File f) {
        File[] children;
        boolean rvalue = false;
        for (File child : children = f.listFiles()) {
            if (child.isDirectory()) {
                this.checkTables(child);
                continue;
            }
            if (!child.getName().endsWith(".class")) continue;
            String cname = child.getAbsolutePath();
            cname = cname.substring(this.rootPath.length() + 1);
            cname = cname.replace(File.separator, ".");
            cname = cname.replace(".class", "");
            this.createDataTables(cname);
        }
        return rvalue;
    }

    private void createDataTables(String cname) {
        try {
            Class<?> cls = Class.forName(cname);
            if (cls.getName().equals(InitializerBase.class.getName())) {
                return;
            }
            boolean match = false;
            if (cls.getSuperclass() != null && cls.getSuperclass().getName().equals(InitializerBase.class.getName())) {
                match = true;
            }
            if (!match) {
                Class<?>[] infs;
                for (Class<?> inf : infs = cls.getInterfaces()) {
                    if (!inf.getName().equals(IInitializer.class.getName())) continue;
                    match = true;
                    break;
                }
            }
            if (match) {
                IInitializer ipins = (IInitializer)cls.newInstance();
                ipins.setJdbcBinder(this);
                ipins.initDb();
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "*** Plugin initialize *** " + cname);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(ClearfyPage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean isMenuTableExist() {
        boolean rvalue = false;
        return rvalue;
    }

    public String getLanguage() {
        return this.getClearfyApplication().getLanguage();
    }

    @Override
    public Locale getLocale() {
        return this.getClearfyApplication().getLocale();
    }

    @Override
    public void bindJdbc(Table ... tables) {
        this.getClearfyApplication().bindJdbc(tables);
    }
}

