/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy;

import java.net.URLClassLoader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.resource.CssUrlReplacer;
import org.clearfy.ClearfySession;
import org.clearfy.IMenuRegister;
import org.clearfy.ISentenceProvider;
import org.clearfy.MenuRegister;
import org.clearfy.admin.l10n.CacheTranslate;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.datawrapper.Table;
import org.clearfy.datawrapper.Translate;
import org.clearfy.index.Index;
import org.clearfy.menu.data.Menu;
import org.clearfy.plugin.scheduler.JobScheduler;
import org.clearfy.zzdeplicated.server.AppServer;
import org.h2.tools.Server;

public class ClearfyApplication
extends AuthenticatedWebApplication
implements IMenuRegister,
ISentenceProvider {
    public static final int SERVER_TYPE_UNKNOWN = 999;
    public static final int DATABASE_STOPED = 0;
    public static final int DATABASE_RUNNING = 1;
    public static final String DATABASE_MODE_TCP = "tcp";
    public static final String DATABASE_MODE_HTTP = "http";
    protected static String JDBC_DRIVER_MANAGER = "org.h2.Driver";
    protected Server httpDbServer;
    protected Server tcpDbServer;
    protected int dbStatus = 0;
    protected int jdbcTcpPort = 0;
    protected int jdbcHttpPort = 0;
    private String language = "";
    private AppServer appServer;
    private URLClassLoader pluginClassLoader;
    private JobScheduler jobScheduler;
    private boolean initialized = false;
    private Translate translate;
    private CacheTranslate cacheTranslate;
    private MenuRegister menuRegister;

    public Class<? extends WebPage> getHomePage() {
        return Index.class;
    }

    @Override
    public void init() {
        super.init();
        this.getApplicationSettings().setUploadProgressUpdatesEnabled(true);
        this.getResourceSettings().setCssCompressor(new CssUrlReplacer());
        Logger.getLogger(ClearfyApplication.class.getName()).info("Application initializing.");
        this.appServer = AppServer.createEnvironment(this.getRealPath("/"));
        this.getRequestCycleSettings().setResponseRequestEncoding("UTF-8");
        this.getMarkupSettings().setDefaultMarkupEncoding("UTF-8");
        JDBC_DRIVER_MANAGER = this.getInitParameter("JdbcDriverName");
        this.startDatabase();
        this.menuRegister = new MenuRegister(this);
        Menu menu = new Menu();
        menu.alterOrCreateTable(this);
        menu.truncate();
        this.language = this.getInitParameter("LANG");
        this.translate = new Translate();
        this.translate.alterOrCreateTable(this);
        this.startScheduler();
        this.cacheTranslate = new CacheTranslate();
    }

    public String getLanguage() {
        return this.language;
    }

    public Locale getLocale() {
        String lng = this.getLanguage();
        String langcode = lng.substring(0, lng.indexOf("_"));
        String companycode = lng.substring(lng.indexOf("_") + 1);
        Locale rvalue = new Locale(langcode, companycode);
        return rvalue;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean b) {
        this.initialized = b;
    }

    public void startScheduler() {
        this.jobScheduler = new JobScheduler(this.getJdbc());
        this.jobScheduler.start();
    }

    public void stopScheduler() {
        this.jobScheduler.stopJobScheduler();
    }

    public void startDatabase() {
        try {
            String tcpPort;
            this.dbStatus = 0;
            Class.forName(JDBC_DRIVER_MANAGER);
            String httpPort = this.getInitParameter("httpPort");
            if (httpPort.length() > 0) {
                this.jdbcHttpPort = Integer.valueOf(httpPort);
                this.httpDbServer = Server.createWebServer("-webPort", httpPort, "-webAllowOthers").start();
                this.dbStatus = 1;
            }
            if ((tcpPort = this.getInitParameter("tcpPort")).length() > 0) {
                this.jdbcTcpPort = Integer.valueOf(tcpPort);
                this.tcpDbServer = Server.createTcpServer("-tcpPort", tcpPort, "-tcpAllowOthers").start();
                this.dbStatus = 1;
            }
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(ClearfyApplication.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stopDatabase() {
        if (this.jobScheduler != null) {
            this.jobScheduler.stopJobScheduler();
        }
        if (this.httpDbServer != null) {
            this.httpDbServer.stop();
        }
        if (this.tcpDbServer != null) {
            this.tcpDbServer.stop();
        }
        this.dbStatus = 0;
    }

    @Override
    public void onDestroy() {
        this.stopDatabase();
    }

    public Server getDatabaseServer() {
        return this.tcpDbServer;
    }

    public int getDatabaseStatus() {
        return this.dbStatus;
    }

    public String getJdbcUrl() {
        String realpath = this.getRealPath("/WEB-INF/h2db");
        realpath = realpath + "/" + this.getInitParameter("h2dbFileName");
        String fmt = "jdbc:h2:tcp:localhost:%d/%s";
        fmt = String.format(fmt, this.jdbcTcpPort, realpath).trim();
        return fmt;
    }

    @Override
    public Jdbc getJdbc() {
        Jdbc controller = new Jdbc(this.getJdbcUrl());
        return controller;
    }

    @Override
    public String getSentence(String sentenceKey) {
        if (this.cacheTranslate.size() > 9999) {
            this.cacheTranslate.clear();
        }
        while (sentenceKey.contains("\n")) {
            sentenceKey = sentenceKey.replace("\n", "\\n");
        }
        String rvalue = sentenceKey;
        String cache = this.cacheTranslate.get(sentenceKey, this.getLanguage());
        if (cache != null) {
            rvalue = cache;
        } else {
            if (!this.translate.isExist()) {
                return sentenceKey;
            }
            this.translate.unselectAllColumn();
            ResultSet rs = this.translate.select(this.translate.TranslateData.setSelectable(true), this.translate.TranslateKey.sameValueOf(sentenceKey), this.translate.Language.sameValueOf(this.language));
            if (rs != null) {
                try {
                    if (rs.next()) {
                        rvalue = this.translate.TranslateData.of(rs);
                    } else {
                        this.translate.clearValues();
                        this.translate.Language.setValue(this.language);
                        this.translate.TranslateData.setValue(sentenceKey);
                        this.translate.TranslateKey.setValue(sentenceKey);
                        this.translate.merge();
                    }
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(ClearfyApplication.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            while (rvalue.contains("\\n")) {
                rvalue = rvalue.replace("\\n", "\n");
            }
            this.cacheTranslate.set(sentenceKey, this.getLanguage(), rvalue);
        }
        return rvalue;
    }

    @Override
    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return ClearfySession.class;
    }

    @Override
    protected Class<? extends WebPage> getSignInPageClass() {
        return Index.class;
    }

    public String getRealPath(String path) {
        String realpath = this.getServletContext().getRealPath(path);
        return realpath;
    }

    public AppServer getApplicationServer() {
        return this.appServer;
    }

    @Override
    public void registMenu(String MenuId, String MenuCaptionKey, int ordinal, String contentHolderId, Class pageClass, int AuthLevel, int allowUpperLevel, Class targetClass, Class sectionClass, boolean hasMenuImage) {
        this.menuRegister.registMenu(MenuId, MenuCaptionKey, ordinal, contentHolderId, pageClass, AuthLevel, allowUpperLevel, targetClass, sectionClass, hasMenuImage);
    }

    @Override
    public void registMenu(String MenuId, String MenuCaptionKey, int ordinal, String contentHolderId, Class pageClass, int AuthLevel, int allowUpperLevel, Class targetClass, Class sectionClass) {
        this.menuRegister.registMenu(MenuId, MenuCaptionKey, ordinal, contentHolderId, pageClass, AuthLevel, allowUpperLevel, targetClass, sectionClass);
    }

    @Override
    public void bindJdbc(Table ... tables) {
        for (Table table : tables) {
            table.setJdbcSupplier(this);
            table.setAliasFromLogicalName(this.getLanguage());
        }
    }
}

