/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.template.TextTemplate;
import org.apache.wicket.util.time.Time;

public abstract class TextTemplateDecorator
extends TextTemplate {
    private static final long serialVersionUID = 1L;
    protected final TextTemplate decorated;

    public TextTemplateDecorator(TextTemplate textTemplate) {
        Args.notNull(textTemplate, "textTemplate");
        this.decorated = textTemplate;
    }

    @Override
    public String asString() {
        return this.asString(Collections.emptyMap());
    }

    @Override
    public String asString(Map<String, ?> variables) {
        StringBuilder b = new StringBuilder();
        b.append(this.getBeforeTemplateContents());
        b.append(this.decorated.asString(variables));
        b.append(this.getAfterTemplateContents());
        return b.toString();
    }

    public abstract String getBeforeTemplateContents();

    public abstract String getAfterTemplateContents();

    @Override
    public void close() throws IOException {
        this.decorated.close();
    }

    public boolean equals(Object obj) {
        return this.decorated.equals(obj);
    }

    @Override
    public String getContentType() {
        return this.decorated.getContentType();
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return this.decorated.getInputStream();
    }

    @Override
    public Locale getLocale() {
        return this.decorated.getLocale();
    }

    public int hashCode() {
        return this.decorated.hashCode();
    }

    @Override
    public Time lastModifiedTime() {
        return this.decorated.lastModifiedTime();
    }

    @Override
    public void setCharset(Charset charset) {
        this.decorated.setCharset(charset);
    }

    @Override
    public void setLastModified(Time lastModified) {
        this.decorated.setLastModified(lastModified);
    }

    @Override
    public void setLocale(Locale locale) {
        this.decorated.setLocale(locale);
    }

    @Override
    public String getString() {
        return this.decorated.getString();
    }

    public String toString() {
        return this.decorated.toString();
    }
}

