/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.reference;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.util.IProvider;

public class ClassReference<T>
implements Serializable,
IProvider<Class<T>> {
    private static final long serialVersionUID = 1L;
    private transient WeakReference<Class<T>> cache;
    private final String name;

    public ClassReference(Class<T> clazz) {
        this.name = clazz.getName();
        this.cache(clazz);
    }

    @Override
    public Class<T> get() {
        Class clazz;
        Class clazz2 = clazz = this.cache != null ? (Class)this.cache.get() : null;
        if (clazz == null) {
            clazz = WicketObjects.resolveClass(this.name);
            if (clazz == null) {
                throw new RuntimeException("Could not resolve class: " + this.name);
            }
            this.cache(clazz);
        }
        return clazz;
    }

    private void cache(Class<T> clazz) {
        this.cache = new WeakReference<Class<Class<T>>>(clazz);
    }

    public static <T> ClassReference<T> of(Class<T> clazz) {
        return new ClassReference<T>(clazz);
    }
}

