/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import java.io.File;
import java.io.IOException;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class StoreSettings {
    private static final int DEFAULT_CACHE_SIZE = 0;
    private static final Bytes DEFAULT_MAX_SIZE_PER_SESSION = Bytes.megabytes(10L);
    private static final int DEFAULT_ASYNCHRONOUS_QUEUE_CAPACITY = 100;
    private int inmemoryCacheSize = 0;
    private Bytes maxSizePerSession = DEFAULT_MAX_SIZE_PER_SESSION;
    private File fileStoreFolder = null;
    private int asynchronousQueueCapacity = 100;
    private boolean isAsynchronous = true;

    public StoreSettings(Application application) {
    }

    public int getInmemoryCacheSize() {
        return this.inmemoryCacheSize;
    }

    public StoreSettings setInmemoryCacheSize(int inmemoryCacheSize) {
        this.inmemoryCacheSize = inmemoryCacheSize;
        return this;
    }

    public Bytes getMaxSizePerSession() {
        return this.maxSizePerSession;
    }

    public StoreSettings setMaxSizePerSession(Bytes maxSizePerSession) {
        this.maxSizePerSession = Args.notNull(maxSizePerSession, "maxSizePerSession");
        return this;
    }

    public File getFileStoreFolder() {
        if (this.fileStoreFolder == null) {
            if (WebApplication.exists()) {
                this.fileStoreFolder = (File)WebApplication.get().getServletContext().getAttribute("javax.servlet.context.tempdir");
            }
            if (this.fileStoreFolder != null) {
                return this.fileStoreFolder;
            }
            try {
                this.fileStoreFolder = File.createTempFile("file-prefix", null).getParentFile();
            }
            catch (IOException e) {
                throw new WicketRuntimeException(e);
            }
        }
        return this.fileStoreFolder;
    }

    public StoreSettings setFileStoreFolder(File fileStoreFolder) {
        this.fileStoreFolder = Args.notNull(fileStoreFolder, "fileStoreFolder");
        return this;
    }

    public int getAsynchronousQueueCapacity() {
        return this.asynchronousQueueCapacity;
    }

    public StoreSettings setAsynchronousQueueCapacity(int queueCapacity) {
        if (queueCapacity < 1) {
            throw new IllegalArgumentException("The capacity of the asynchronous queue should be at least 1.");
        }
        this.asynchronousQueueCapacity = queueCapacity;
        return this;
    }

    public StoreSettings setAsynchronous(boolean async) {
        this.isAsynchronous = async;
        return this;
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }
}

