/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import org.apache.wicket.Component;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authentication.strategy.DefaultAuthenticationStrategy;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.IUnauthorizedResourceRequestListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.core.util.crypt.KeyInSessionSunJceCryptFactory;
import org.apache.wicket.settings.DefaultUnauthorizedResourceRequestListener;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.lang.Args;

public class SecuritySettings {
    public static final String DEFAULT_ENCRYPTION_KEY = "WiCkEt-FRAMEwork";
    private IAuthorizationStrategy authorizationStrategy = IAuthorizationStrategy.ALLOW_ALL;
    private IAuthenticationStrategy authenticationStrategy;
    private ICryptFactory cryptFactory;
    private boolean enforceMounts = false;
    private static final IUnauthorizedComponentInstantiationListener DEFAULT_UNAUTHORIZED_COMPONENT_INSTANTIATION_LISTENER = new IUnauthorizedComponentInstantiationListener(){

        @Override
        public void onUnauthorizedInstantiation(Component component) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
    };
    private IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener = DEFAULT_UNAUTHORIZED_COMPONENT_INSTANTIATION_LISTENER;
    private static final IUnauthorizedResourceRequestListener DEFAULT_UNAUTHORIZED_RESOURCE_REQUEST_LISTENER = new DefaultUnauthorizedResourceRequestListener();
    private IUnauthorizedResourceRequestListener unauthorizedResourceRequestListener = DEFAULT_UNAUTHORIZED_RESOURCE_REQUEST_LISTENER;

    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.authorizationStrategy;
    }

    public synchronized ICryptFactory getCryptFactory() {
        if (this.cryptFactory == null) {
            this.cryptFactory = new KeyInSessionSunJceCryptFactory();
        }
        return this.cryptFactory;
    }

    public boolean getEnforceMounts() {
        return this.enforceMounts;
    }

    public IUnauthorizedComponentInstantiationListener getUnauthorizedComponentInstantiationListener() {
        return this.unauthorizedComponentInstantiationListener;
    }

    public SecuritySettings setAuthorizationStrategy(IAuthorizationStrategy strategy) {
        Args.notNull(strategy, "strategy");
        this.authorizationStrategy = strategy;
        return this;
    }

    public SecuritySettings setCryptFactory(ICryptFactory cryptFactory) {
        Args.notNull(cryptFactory, "cryptFactory");
        this.cryptFactory = cryptFactory;
        return this;
    }

    public SecuritySettings setEnforceMounts(boolean enforce) {
        this.enforceMounts = enforce;
        return this;
    }

    public SecuritySettings setUnauthorizedComponentInstantiationListener(IUnauthorizedComponentInstantiationListener listener) {
        this.unauthorizedComponentInstantiationListener = listener == null ? DEFAULT_UNAUTHORIZED_COMPONENT_INSTANTIATION_LISTENER : listener;
        return this;
    }

    public IUnauthorizedResourceRequestListener getUnauthorizedResourceRequestListener() {
        return this.unauthorizedResourceRequestListener;
    }

    public SecuritySettings setUnauthorizedResourceRequestListener(IUnauthorizedResourceRequestListener listener) {
        this.unauthorizedResourceRequestListener = listener == null ? DEFAULT_UNAUTHORIZED_RESOURCE_REQUEST_LISTENER : listener;
        return this;
    }

    public IAuthenticationStrategy getAuthenticationStrategy() {
        if (this.authenticationStrategy == null) {
            this.authenticationStrategy = new DefaultAuthenticationStrategy("LoggedIn");
        }
        return this.authenticationStrategy;
    }

    public SecuritySettings setAuthenticationStrategy(IAuthenticationStrategy strategy) {
        this.authenticationStrategy = strategy;
        return this;
    }
}

