/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.lang.reflect.Field;
import java.util.Set;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.collections.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ClassScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassScanner.class);
    private final Set<String> scannedClasses = new ConcurrentHashSet<String>();

    abstract boolean foundResourceReference(ResourceReference var1);

    ClassScanner() {
    }

    public final void clearCache() {
        this.scannedClasses.clear();
    }

    public int scanClass(Class<?> klass) {
        if (klass == null) {
            return 0;
        }
        int count = 0;
        String className = klass.getName();
        if (!this.scannedClasses.contains(className)) {
            this.scannedClasses.add(className);
            for (Field f : klass.getDeclaredFields()) {
                if ((f.getModifiers() & 8) != 8) continue;
                f.setAccessible(true);
                try {
                    Object value = f.get(null);
                    if (!(value instanceof ResourceReference) || !this.foundResourceReference((ResourceReference)value)) continue;
                    ++count;
                }
                catch (Exception e) {
                    log.warn("Error accessing object property", e);
                }
            }
            count += this.scanClass(klass.getSuperclass());
        }
        return count;
    }
}

