/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.util.string.Strings;

public class UrlUtils {
    protected UrlUtils() {
    }

    public static boolean isRelative(String url) {
        return url != null && !url.startsWith("/") && !url.matches("^\\w+\\:\\/\\/.*") && !url.startsWith("#");
    }

    public static String rewriteToContextRelative(String url, IRequestCycle requestCycle) {
        if (UrlUtils.isRelative(url)) {
            return requestCycle.getUrlRenderer().renderContextRelativeUrl(url);
        }
        return url;
    }

    public static String normalizePath(String path) {
        if (Strings.isEmpty(path)) {
            return "";
        }
        if (!(path = path.trim()).startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

