/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServletContext
implements ServletContext {
    private static final Logger log = LoggerFactory.getLogger(MockServletContext.class);
    private final Application application;
    private final ValueMap attributes = new ValueMap();
    private final ValueMap initParameters = new ValueMap();
    private final Map<String, ServletRegistration.Dynamic> servletRegistration = new HashMap<String, ServletRegistration.Dynamic>();
    private final ValueMap mimeTypes = new ValueMap();
    private File webappRoot;

    public MockServletContext(Application application, String path) {
        this.application = application;
        this.webappRoot = null;
        if (path != null) {
            this.webappRoot = new File(path);
            if (!this.webappRoot.exists() || !this.webappRoot.isDirectory()) {
                log.warn("WARNING: The webapp root directory is invalid: " + path);
                this.webappRoot = null;
            }
        }
        String workFolder = System.getProperty("wicket.tester.work.folder", "target/work/");
        File file = new File(workFolder);
        try {
            file.mkdirs();
        }
        catch (SecurityException sx) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            file = new File(tmpDir);
        }
        this.attributes.put("javax.servlet.context.tempdir", (Object)file);
        this.mimeTypes.put("html", (Object)"text/html");
        this.mimeTypes.put("htm", (Object)"text/html");
        this.mimeTypes.put("css", (Object)"text/css");
        this.mimeTypes.put("xml", (Object)"text/xml");
        this.mimeTypes.put("js", (Object)"text/javascript");
        this.mimeTypes.put("gif", (Object)"image/gif");
        this.mimeTypes.put("jpg", (Object)"image/jpeg");
        this.mimeTypes.put("png", (Object)"image/png");
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, (Object)value);
    }

    public void addMimeType(String fileExtension, String mimeType) {
        this.mimeTypes.put(fileExtension, (Object)mimeType);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    @Override
    public ServletContext getContext(String name) {
        return this;
    }

    @Override
    public String getInitParameter(String name) {
        return this.initParameters.getString(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        return false;
    }

    @Override
    public String getMimeType(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1 || index == name.length() - 1) {
            return null;
        }
        return this.mimeTypes.getString(name.substring(index + 1));
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public int getEffectiveMajorVersion() {
        return 3;
    }

    @Override
    public int getEffectiveMinorVersion() {
        return 0;
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        return this.getRequestDispatcher(name);
    }

    @Override
    public String getRealPath(String name) {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(this.webappRoot, name)).exists()) {
            return null;
        }
        return f.getPath();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(final String name) {
        return new RequestDispatcher(){

            @Override
            public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
                servletResponse.getWriter().write("FORWARD TO RESOURCE: " + name);
            }

            @Override
            public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
                servletResponse.getWriter().write("INCLUDE OF RESOURCE: " + name);
            }
        };
    }

    @Override
    public URL getResource(String name) throws MalformedURLException {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        URL result = null;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((f = new File(this.webappRoot, name)).exists()) {
            result = f.toURI().toURL();
        }
        if (result == null) {
            result = this.getClass().getClassLoader().getResource("META-INF/resources/" + name);
        }
        return result;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(this.webappRoot, name)).exists()) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Set<String> getResourcePaths(String name) {
        if (this.webappRoot == null) {
            return new HashSet<String>();
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String[] elements = null;
        elements = name.trim().length() == 0 ? new String[]{} : Strings.split(name, '/');
        File current = this.webappRoot;
        for (String element : elements) {
            File[] files = current.listFiles();
            boolean match = false;
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().equals(element) || !file.isDirectory()) continue;
                    current = file;
                    match = true;
                    break;
                }
            }
            if (match) continue;
            return null;
        }
        File[] files = current.listFiles();
        HashSet<String> result = new HashSet<String>();
        if (files != null) {
            int stripLength = this.webappRoot.getPath().length();
            for (File file : files) {
                String s = file.getPath().substring(stripLength).replace('\\', '/');
                if (file.isDirectory()) {
                    s = s + "/";
                }
                result.add(s);
            }
        }
        return result;
    }

    @Override
    public String getServerInfo() {
        return "Wicket Mock Test Environment v1.0";
    }

    @Override
    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    @Override
    public String getServletContextName() {
        return this.application.getName();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        try {
            return this.addServlet(servletName, Class.forName(className).asSubclass(Servlet.class));
        }
        catch (ClassNotFoundException e) {
            throw new WicketRuntimeException(e);
        }
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        ServletRegistration.Dynamic mockRegistration = (ServletRegistration.Dynamic)Proxy.newProxyInstance(ServletRegistration.Dynamic.class.getClassLoader(), new Class[]{ServletRegistration.Dynamic.class}, (InvocationHandler)new MockedServletRegistationHandler(servletName));
        this.servletRegistration.put(servletName, mockRegistration);
        return mockRegistration;
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        try {
            return this.addServlet(servletName, servletClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WicketRuntimeException(e);
        }
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)((Servlet)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WicketRuntimeException(e);
        }
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        return this.servletRegistration.get(servletName);
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.servletRegistration;
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return null;
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return null;
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return null;
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return null;
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    @Override
    public void addListener(String className) {
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return null;
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return null;
    }

    @Override
    public void declareRoles(String ... roleNames) {
    }

    @Override
    public Enumeration<String> getServletNames() {
        return null;
    }

    @Override
    public Enumeration<Servlet> getServlets() {
        return null;
    }

    @Override
    public void log(Exception e, String msg) {
        log.error(msg, e);
    }

    @Override
    public void log(String msg) {
        log.info(msg);
    }

    @Override
    public void log(String msg, Throwable cause) {
        log.error(msg, cause);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    @Override
    public String getContextPath() {
        return "";
    }

    class MockedServletRegistationHandler
    implements InvocationHandler {
        private final Collection<String> servletName;

        public MockedServletRegistationHandler(String servletName) {
            this.servletName = Arrays.asList(servletName);
        }

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getMappings")) {
                return this.servletName;
            }
            return null;
        }
    }
}

