/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Map;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.util.collections.MostRecentlyUsedMap;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;

class StoredResponsesMap
extends MostRecentlyUsedMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private final Duration lifetime;

    public StoredResponsesMap(int maxEntries, Duration lifetime) {
        super(maxEntries);
        this.lifetime = lifetime;
    }

    @Override
    protected synchronized boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
        Duration elapsedTime;
        Value value;
        boolean removed = super.removeEldestEntry(eldest);
        if (!removed && (value = (Value)eldest.getValue()) != null && this.lifetime.lessThanOrEqual(elapsedTime = Time.now().subtract(value.creationTime))) {
            this.removedValue = value.response;
            removed = true;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedWebResponse put(String key, Object bufferedResponse) {
        Value oldValue;
        if (!(bufferedResponse instanceof BufferedWebResponse)) {
            throw new IllegalArgumentException(StoredResponsesMap.class.getSimpleName() + " can store only instances of " + BufferedWebResponse.class.getSimpleName());
        }
        Value value = new Value();
        value.creationTime = Time.now();
        value.response = (BufferedWebResponse)bufferedResponse;
        StoredResponsesMap storedResponsesMap = this;
        synchronized (storedResponsesMap) {
            oldValue = super.put(key, value);
        }
        return oldValue != null ? oldValue.response : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedWebResponse get(Object key) {
        Value value;
        BufferedWebResponse result = null;
        StoredResponsesMap storedResponsesMap = this;
        synchronized (storedResponsesMap) {
            value = (Value)super.get(key);
        }
        if (value != null) {
            Duration elapsedTime = Time.now().subtract(value.creationTime);
            if (this.lifetime.greaterThan(elapsedTime)) {
                result = value.response;
            } else {
                this.remove(key);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedWebResponse remove(Object key) {
        Value removedValue;
        StoredResponsesMap storedResponsesMap = this;
        synchronized (storedResponsesMap) {
            removedValue = (Value)super.remove(key);
        }
        return removedValue != null ? removedValue.response : null;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    private static class Value {
        private BufferedWebResponse response;
        private Time creationTime;

        private Value() {
        }
    }
}

