/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import javax.servlet.http.Cookie;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Time;

class HeaderBufferingWebResponse
extends WebResponse
implements IMetaDataBufferingWebResponse {
    private final WebResponse originalResponse;
    private final BufferedWebResponse bufferedResponse;
    private boolean buffering = true;

    public HeaderBufferingWebResponse(WebResponse originalResponse) {
        this.originalResponse = originalResponse;
        this.bufferedResponse = new BufferedWebResponse(originalResponse);
    }

    private void stopBuffering() {
        if (this.buffering) {
            this.bufferedResponse.writeTo(this.originalResponse);
            this.buffering = false;
        }
    }

    private WebResponse getMetaResponse() {
        if (this.buffering) {
            return this.bufferedResponse;
        }
        return this.originalResponse;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.getMetaResponse().addCookie(cookie);
    }

    @Override
    public void clearCookie(Cookie cookie) {
        this.getMetaResponse().clearCookie(cookie);
    }

    @Override
    public void flush() {
        this.stopBuffering();
        this.originalResponse.flush();
    }

    @Override
    public boolean isRedirect() {
        return this.getMetaResponse().isRedirect();
    }

    @Override
    public void sendError(int sc, String msg) {
        this.getMetaResponse().sendError(sc, msg);
    }

    @Override
    public void sendRedirect(String url) {
        this.getMetaResponse().sendRedirect(url);
    }

    @Override
    public void setContentLength(long length) {
        this.getMetaResponse().setContentLength(length);
    }

    @Override
    public void setContentType(String mimeType) {
        this.getMetaResponse().setContentType(mimeType);
    }

    @Override
    public void setDateHeader(String name, Time date) {
        Args.notNull(date, "date");
        this.getMetaResponse().setDateHeader(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        this.getMetaResponse().setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.getMetaResponse().addHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        this.getMetaResponse().setStatus(sc);
    }

    @Override
    public void disableCaching() {
        this.getMetaResponse().disableCaching();
    }

    @Override
    public String encodeURL(CharSequence url) {
        return this.originalResponse.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(CharSequence url) {
        return this.originalResponse.encodeRedirectURL(url);
    }

    @Override
    public void write(CharSequence sequence) {
        this.stopBuffering();
        this.originalResponse.write(sequence);
    }

    @Override
    public void write(byte[] array) {
        this.stopBuffering();
        this.originalResponse.write(array);
    }

    @Override
    public void write(byte[] array, int offset, int length) {
        this.stopBuffering();
        this.originalResponse.write(array, offset, length);
    }

    @Override
    public void reset() {
        if (!this.buffering) {
            throw new IllegalStateException("Response is no longer buffering!");
        }
        this.bufferedResponse.reset();
    }

    @Override
    public void writeMetaData(WebResponse webResponse) {
        this.bufferedResponse.writeMetaData(webResponse);
    }

    @Override
    public Object getContainerResponse() {
        return this.originalResponse.getContainerResponse();
    }
}

